% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IEX_Market_Data.R
\name{crypto}
\alias{crypto}
\title{Returns quote for Crypto Currencies supported by the IEX Cloud API.}
\usage{
crypto(x, iex_sk)
}
\arguments{
\item{x}{A charcter vector that can include one or multiple  Tickers / Stocks Symbols}

\item{iex_sk}{is a character vector that include IEX Cloud API Secret Token}
}
\value{
Data frame that include Crypto currency financial details
To retrieve list of 18 Cyrpto Currency Symbols available in IEX as of April 2019.
}
\description{
For more details, visit:\url{https://iexcloud.io/docs/api/#crypto}
}
\examples{
\donttest{
  data(package = "Riex")
  CrytoSymbols <- crypto_symbols
}
\donttest{
  crypto("BTCUSDT")
}
}
\seealso{
Investors Exchange `IEX` developer guide \url{https://iexcloud.io/docs/api/}

Investors Exchange Group (IEX Group) offers flexible and salable pricing.\url{https://iexcloud.io/pricing/}

View Investors Exchange Group (IEX Group) terms of use and subscription levels.\url{https://iexcloud.io/terms/}

Package `iexcloudR`\url{https://github.com/schardtbc/iexcloudR}
}
\author{
Myriam Ibrahim
}
