% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_calc_all_scores_prec.R
\name{RiskScoresCalc}
\alias{RiskScoresCalc}
\alias{calc_scores}
\title{Commonly used cardiovascular risk scores for the prediction of major cardiac events (MACE)}
\usage{
calc_scores(
  data,
  typical_symptoms.num = typical_symptoms.num,
  ecg.normal = ecg.normal,
  abn.repolarisation = abn.repolarisation,
  ecg.st.depression = ecg.st.depression,
  Age = Age,
  diabetes = diabetes,
  smoker = smoker,
  hypertension = hypertension,
  hyperlipidaemia = hyperlipidaemia,
  family.history = family.history,
  atherosclerotic.disease = atherosclerotic.disease,
  presentation_hstni = presentation_hstni,
  Gender = Gender,
  sweating = sweating,
  pain.radiation = pain.radiation,
  pleuritic = pleuritic,
  palpation = palpation,
  ecg.twi = ecg.twi,
  second_hstni = second_hstni,
  killip.class = killip.class,
  heart.rate = heart.rate,
  systolic.bp = systolic.bp,
  aspirin = aspirin,
  number.of.episodes.24h = number.of.episodes.24h,
  previous.pci = previous.pci,
  creat = creat,
  previous.cabg = previous.cabg,
  total.chol = total.chol,
  total.hdl = total.hdl,
  Ethnicity = Ethnicity
)
}
\arguments{
\item{data}{A data frame with all the variables needed for calculation:}

\item{typical_symptoms.num}{a numeric vector of the number of typical symptoms; renames alternative column name}

\item{ecg.normal}{a binary numeric vector,  1 = yes and 0 = no; renames alternative column name}

\item{abn.repolarisation}{a binary numeric vector,  1 = yes and 0 = no; renames alternative column name}

\item{ecg.st.depression}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{Age}{a numeric vector of age values, in years; renames alternative column name}

\item{diabetes}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{smoker}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{hypertension}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{hyperlipidaemia}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{family.history}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{atherosclerotic.disease}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{presentation_hstni}{a continuous numeric vector of the troponin levels; renames alternative column name}

\item{Gender}{a binary character vector of sex values. Categories should include only 'male' or 'female'; renames alternative column name}

\item{sweating}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{pain.radiation}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{pleuritic}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{palpation}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{ecg.twi}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{second_hstni}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{killip.class}{a numeric vector of killip class values, 1 to 4; renames alternative column name}

\item{heart.rate}{a numeric vector of heart rate continuous values; renames alternative column name}

\item{systolic.bp}{a numeric vector of systolic blood pressure continuous values; renames alternative column name}

\item{aspirin}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{number.of.episodes.24h}{a numeric vector of number of angina episodes in 24 hours; renames alternative column name}

\item{previous.pci}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{creat}{a continuous numeric vector of the creatine levels}

\item{previous.cabg}{a binary numeric vector, 1 = yes and 0 = no; renames alternative column name}

\item{total.chol}{a numeric vector of total cholesterol values, in mmol/L; renames alternative column name}

\item{total.hdl}{a numeric vector of total high density lipoprotein HDL values, in mmol/L; renames alternative column name}

\item{Ethnicity}{a character vector, 'white', 'black', 'asian', or other}
}
\value{
a data frame with two extra columns including all the cardiovascular risk score calculations
and their classifications
}
\description{
This function implements seven cardiovascular risk scores row wise
in a data frame with the required variables. It would then retrieve a data
frame with two extra columns for each risk score including their calculations and classifications
}
\examples{

# Create a data frame or list with the necessary variables
# Set the number of rows
num_rows <- 100

# Create a larger dataset with 100 rows
cohort_xx <- data.frame(
  typical_symptoms.num = as.numeric(sample(0:6, num_rows, replace = TRUE)),
  ecg.normal = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  abn.repolarisation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  ecg.st.depression = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  Age = as.numeric(sample(30:80, num_rows, replace = TRUE)),
  diabetes = sample(c(1, 0), num_rows, replace = TRUE),
  smoker = sample(c(1, 0), num_rows, replace = TRUE),
  hypertension = sample(c(1, 0), num_rows, replace = TRUE),
  hyperlipidaemia = sample(c(1, 0), num_rows, replace = TRUE),
  family.history = sample(c(1, 0), num_rows, replace = TRUE),
  atherosclerotic.disease = sample(c(1, 0), num_rows, replace = TRUE),
  presentation_hstni = as.numeric(sample(10:100, num_rows, replace = TRUE)),
  Gender = sample(c("male", "female"), num_rows, replace = TRUE),
  sweating = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  pain.radiation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  pleuritic = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  palpation = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  ecg.twi = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  second_hstni = as.numeric(sample(1:200, num_rows, replace = TRUE)),
  killip.class = as.numeric(sample(1:4, num_rows, replace = TRUE)),
  systolic.bp = as.numeric(sample(0:300, num_rows, replace = TRUE)),
  heart.rate = as.numeric(sample(0:300, num_rows, replace = TRUE)),
  creat = as.numeric(sample(0:4, num_rows, replace = TRUE)),
  cardiac.arrest = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  previous.pci = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  previous.cabg = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  aspirin = as.numeric(sample(c(0, 1), num_rows, replace = TRUE)),
  number.of.episodes.24h = as.numeric(sample(0:20, num_rows, replace = TRUE)),
  total.chol = as.numeric(sample(5:100, num_rows, replace = TRUE)),
  total.hdl = as.numeric(sample(2:5, num_rows, replace = TRUE)),
  Ethnicity = sample(c("white", "black", "asian", "other"), num_rows, replace = TRUE)
)


# Call the function with the cohort_xx

new_data_frame <- calc_scores(data = cohort_xx)

}
\keyword{Age}
\keyword{Cardiovascular}
\keyword{Gender}
\keyword{abn.repolarisation}
\keyword{aspirin}
\keyword{atherosclerotic.disease}
\keyword{diabetes}
\keyword{ecg.normal}
\keyword{ecg.st.depression}
\keyword{ecg.twi}
\keyword{family.history}
\keyword{heart.rate}
\keyword{hyperlipidaemia}
\keyword{hypertension}
\keyword{killip.class}
\keyword{number.of.episodes.24h}
\keyword{pain.radiation}
\keyword{palpation}
\keyword{pleuritic}
\keyword{presentation_hstni}
\keyword{previous.cabg}
\keyword{previous.pci}
\keyword{risk}
\keyword{scores}
\keyword{second_hstni}
\keyword{smoker}
\keyword{sweating}
\keyword{systolic.bp}
\keyword{total.chol}
\keyword{total.hdl}
\keyword{typical_symptoms.num}
