% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{skewCoeff}
\alias{skewCoeff}
\title{Adjusted Fisher-Pearson Skewness Coefficient with Sample-size Correction Factor}
\usage{
skewCoeff(data, sd)
}
\arguments{
\item{data}{The data for which skewness is computed (vector)}

\item{sd}{The population standard deviation, used to compute skewness (scalar)}
}
\value{
The skewness value (scalar)
}
\description{
Adjusted Fisher-Pearson Skewness Coefficient with Sample-size Correction Factor
}
\examples{
values <- rnorm(100)
x <- skewCoeff(data = values,sd = sd(values))
}
\references{
Shreve, Joni N. and Donna Dea Holland . 2018. SAS® Certification Prep
            Guide: Statistical Business Analysis Using SAS®9. Cary, NC: SAS Institute Inc.
}
