% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizations.R
\name{logitXform}
\alias{logitXform}
\title{Logit/Log-Odds Transformation}
\usage{
logitXform(sample, divisor = 2)
}
\arguments{
\item{sample}{The input data (vector, matrix, or dataframe)}

\item{divisor}{Number used to modify epsilon enroute to the empirical logit, in cases of output 
consisting of a single distinct value (scalar)}
}
\value{
The logit-transformed data (vector)
}
\description{
This function transforms data via the logit/log-odds transformation.
}
\details{
Initially, features of the input data are extracted and used to determine
an initial transformation to perform.

All forms of data representing an underlying discrete scale are converted to proportions
of the total sample size, if needed. In these cases, values should be stored such that
elements are in absolute frequency, relative frequency, or percentage form.

For non-count data, variables are shifted and bounded at [0,1] in a manner analogous to
the potential transformations of the scale performed by arcsineXform() prior to the arcine,
although transformed values are not expected to outperform more suitable transformations.

Then, the empirical logit transformation is applied to avoid zeroes or ones, and the data
are transformed by taking the log-odds/logit of each value.
}
\examples{
values <- rnorm(100)
x <- logitXform(values)
}
\references{
Stevens, S., Valderas, J. M., Doran, T., Perera, R., & Kontopantelis, E. (2016). Analysing indicators of performance, satisfaction, or safety using empirical logit transformation. bmj, 352.

            Osborne, J. W. (2002). Notes on the use of data transformations. Practical Assessment, Research and Evaluation, 9(1), 42-50.

            Osborne, J. W. (2002). The Effects of Minimum Values on Data Transformations. Retrieved from https://files.eric.ed.gov/fulltext/ED463313.pdf

            Warton, D. I., & Hui, F. K. (2011). The arcsine is asinine: the analysis of proportions in ecology. Ecology, 92(1), 3-10.
}
