% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlgt.R
\name{rlgt}
\alias{rlgt}
\title{Fit an Rlgt model}
\usage{
rlgt(
  y,
  seasonality = 1,
  seasonality2 = 1,
  seasonality.type = c("multiplicative", "generalized"),
  error.size.method = c("std", "innov"),
  level.method = c("HW", "seasAvg", "HW_sAvg"),
  xreg = NULL,
  control = rlgt.control(),
  verbose = FALSE,
  method = "Stan",
  experimental = ""
)
}
\arguments{
\item{y}{time-series data for training (provided as a numeric vector, or a ts, or msts object).}

\item{seasonality}{This specification of seasonality will be overridden by frequency of y, if y is of ts or msts class. 
1 by default, i.e. no seasonality.}

\item{seasonality2}{Second seasonality. If larger than 1, a dual seasonality model will be used. 
However, this is experimental. If not specified and multiple seasonality time series (of msts class) is used,
a single seasonality model will be applied, one with seasonality equal to the largest of seasonalities of the time series. 
1 by default, i.e. no seasonality or single seasonality.}

\item{seasonality.type}{Either "multiplicative" (default) or "generalized". 
The latter seasonality generalizes additive and multiplicative seasonality types.}

\item{error.size.method}{Function providing size of the error. Either "std" (monotonically, but slower than proportionally, growing with the series values) or 
"innov" (proportional to a smoothed abs size of innovations, i.e. surprises)}

\item{level.method}{"HW",  "seasAvg", "HW_sAvg". Here, "HW" follows Holt-Winters approach. 
"seasAvg" calculates level as a smoothed average of the last seasonality number of points (or seasonality2 of them for the dual seasonality model),
and HW_sAvg is an weighted average of HW and seasAvg methods.}

\item{xreg}{Optionally, a vector or matrix of external regressors, which must have the same number of rows as y.}

\item{control}{list of control parameters, e.g. hyperparameter values for the model's prior distributions, number of fitting interations etc.}

\item{verbose}{whether verbose information should be printed (Boolean value only), default \code{FALSE}.}

\item{method}{Sampling method, default \code{Stan}.}

\item{experimental}{Run different versions ("nostudent", "noglobal", "nohet", "ets") for ablation studies}
}
\value{
\code{\link{rlgtfit}} object
}
\description{
The main function to fit an rlgt model. It fits the parameter values with MCMC.
}
\examples{
# The following is a toy example that runs within a few seconds. To get good 
# fitting results the number of iterations should be set to at least 2000, and 
# 4 chains should be used (the default). To speed up computation the number of 
# cores should also be adjusted (default is 4).

rlgt_model <- rlgt(lynx, 
       control=rlgt.control(MAX_NUM_OF_REPEATS=1, NUM_OF_ITER=50, NUM_OF_CHAINS = 1, 
                            NUM_OF_CORES = 1), verbose=TRUE)

# print the model details
print(rlgt_model)

\dontrun{demo(exampleScript)}

}
