// Generated by rstantools.  Do not edit by hand.

/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_nostudent_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 89> locations_array__ =
  {" (found before start of program)",
  " (in 'nostudent', line 20, column 2 to column 21)",
  " (in 'nostudent', line 20, column 22 to column 37)",
  " (in 'nostudent', line 21, column 1 to column 36)",
  " (in 'nostudent', line 22, column 1 to column 21)",
  " (in 'nostudent', line 23, column 1 to column 29)",
  " (in 'nostudent', line 24, column 1 to column 28)",
  " (in 'nostudent', line 25, column 1 to column 29)",
  " (in 'nostudent', line 26, column 1 to column 12)",
  " (in 'nostudent', line 27, column 1 to column 37)",
  " (in 'nostudent', line 28, column 1 to column 16)",
  " (in 'nostudent', line 29, column 1 to column 36)",
  " (in 'nostudent', line 30, column 1 to column 38)",
  " (in 'nostudent', line 31, column 1 to column 31)",
  " (in 'nostudent', line 32, column 1 to column 30)",
  " (in 'nostudent', line 35, column 1 to column 56)",
  " (in 'nostudent', line 36, column 1 to column 22)",
  " (in 'nostudent', line 37, column 1 to column 13)",
  " (in 'nostudent', line 38, column 1 to column 13)",
  " (in 'nostudent', line 39, column 1 to column 27)",
  " (in 'nostudent', line 40, column 1 to column 38)",
  " (in 'nostudent', line 45, column 2 to column 23)",
  " (in 'nostudent', line 43, column 2 to column 33)",
  " (in 'nostudent', line 42, column 1 to line 45, column 23)",
  " (in 'nostudent', line 50, column 3 to column 28)",
  " (in 'nostudent', line 48, column 3 to column 40)",
  " (in 'nostudent', line 47, column 1 to line 50, column 28)",
  " (in 'nostudent', line 52, column 1 to column 20)",
  " (in 'nostudent', line 53, column 1 to column 14)",
  " (in 'nostudent', line 54, column 1 to column 69)",
  " (in 'nostudent', line 55, column 1 to column 18)",
  " (in 'nostudent', line 58, column 2 to column 79)",
  " (in 'nostudent', line 59, column 2 to column 47)",
  " (in 'nostudent', line 60, column 2 to column 59)",
  " (in 'nostudent', line 64, column 3 to column 26)",
  " (in 'nostudent', line 62, column 3 to column 97)",
  " (in 'nostudent', line 61, column 2 to line 64, column 26)",
  " (in 'nostudent', line 57, column 16 to line 65, column 2)",
  " (in 'nostudent', line 57, column 1 to line 65, column 2)",
  " (in 'nostudent', line 68, column 1 to column 35)",
  " (in 'nostudent', line 68, column 31 to column 32)",
  " (in 'nostudent', line 69, column 1 to column 57)",
  " (in 'nostudent', line 69, column 45 to column 54)",
  " (in 'nostudent', line 70, column 1 to column 33)",
  " (in 'nostudent', line 71, column 1 to column 54)",
  " (in 'nostudent', line 76, column 4 to column 38)",
  " (in 'nostudent', line 76, column 34 to column 35)",
  " (in 'nostudent', line 73, column 1 to line 76, column 38)",
  " (in 'nostudent', line 74, column 2 to column 50)",
  " (in 'nostudent', line 74, column 46 to column 47)",
  " (in 'nostudent', line 82, column 2 to column 25)",
  " (in 'nostudent', line 83, column 2 to column 27)",
  " (in 'nostudent', line 81, column 8 to line 84, column 2)",
  " (in 'nostudent', line 79, column 2 to column 37)",
  " (in 'nostudent', line 80, column 2 to column 38)",
  " (in 'nostudent', line 78, column 21 to line 81, column 2)",
  " (in 'nostudent', line 78, column 1 to line 84, column 2)",
  " (in 'nostudent', line 85, column 2 to column 30)",
  " (in 'nostudent', line 91, column 4 to column 73)",
  " (in 'nostudent', line 89, column 4 to column 65)",
  " (in 'nostudent', line 88, column 3 to line 91, column 73)",
  " (in 'nostudent', line 87, column 16 to line 92, column 2)",
  " (in 'nostudent', line 87, column 1 to line 92, column 2)",
  " (in 'nostudent', line 3, column 1 to column 25)",
  " (in 'nostudent', line 4, column 1 to column 20)",
  " (in 'nostudent', line 4, column 22 to column 41)",
  " (in 'nostudent', line 5, column 1 to column 25)",
  " (in 'nostudent', line 6, column 1 to column 22)",
  " (in 'nostudent', line 6, column 23 to column 44)",
  " (in 'nostudent', line 7, column 1 to column 16)",
  " (in 'nostudent', line 8, column 17 to column 18)",
  " (in 'nostudent', line 8, column 1 to column 22)",
  " (in 'nostudent', line 9, column 1 to column 31)",
  " (in 'nostudent', line 9, column 32 to column 61)",
  " (in 'nostudent', line 10, column 1 to column 37)",
  " (in 'nostudent', line 11, column 1 to column 41)",
  " (in 'nostudent', line 12, column 1 to column 16)",
  " (in 'nostudent', line 13, column 8 to column 9)",
  " (in 'nostudent', line 13, column 11 to column 12)",
  " (in 'nostudent', line 13, column 1 to column 19)",
  " (in 'nostudent', line 14, column 17 to column 18)",
  " (in 'nostudent', line 14, column 1 to column 34)",
  " (in 'nostudent', line 17, column 1 to column 51)",
  " (in 'nostudent', line 20, column 9 to column 10)",
  " (in 'nostudent', line 36, column 17 to column 18)",
  " (in 'nostudent', line 37, column 8 to column 9)",
  " (in 'nostudent', line 38, column 8 to column 9)",
  " (in 'nostudent', line 39, column 17 to column 18)",
  " (in 'nostudent', line 40, column 17 to column 18)"};
#include <stan_meta_header.hpp>
class model_nostudent final : public model_base_crtp<model_nostudent> {
private:
  double CAUCHY_SD;
  double MIN_POW_TREND;
  double MAX_POW_TREND;
  double MIN_SIGMA;
  double MIN_NU;
  double MAX_NU;
  int N;
  Eigen::Matrix<double,-1,1> y_data__;
  double POW_TREND_ALPHA;
  double POW_TREND_BETA;
  int USE_REGRESSION;
  int USE_SMOOTHED_ERROR;
  int J;
  Eigen::Matrix<double,-1,-1> xreg_data__;
  Eigen::Matrix<double,-1,1> REG_CAUCHY_SD_data__;
  double reg0CauchySd;
  Eigen::Map<Eigen::Matrix<double,-1,1>> y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,-1>> xreg{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> REG_CAUCHY_SD{nullptr, 0};
public:
  ~model_nostudent() {}
  model_nostudent(stan::io::var_context& context__, unsigned int
                  random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_nostudent_namespace::model_nostudent";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 63;
      context__.validate_dims("data initialization", "CAUCHY_SD", "double",
        std::vector<size_t>{});
      CAUCHY_SD = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 63;
      CAUCHY_SD = context__.vals_r("CAUCHY_SD")[(1 - 1)];
      current_statement__ = 63;
      stan::math::check_greater_or_equal(function__, "CAUCHY_SD", CAUCHY_SD,
        0);
      current_statement__ = 64;
      context__.validate_dims("data initialization", "MIN_POW_TREND",
        "double", std::vector<size_t>{});
      MIN_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 64;
      MIN_POW_TREND = context__.vals_r("MIN_POW_TREND")[(1 - 1)];
      current_statement__ = 65;
      context__.validate_dims("data initialization", "MAX_POW_TREND",
        "double", std::vector<size_t>{});
      MAX_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 65;
      MAX_POW_TREND = context__.vals_r("MAX_POW_TREND")[(1 - 1)];
      current_statement__ = 66;
      context__.validate_dims("data initialization", "MIN_SIGMA", "double",
        std::vector<size_t>{});
      MIN_SIGMA = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 66;
      MIN_SIGMA = context__.vals_r("MIN_SIGMA")[(1 - 1)];
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "MIN_SIGMA", MIN_SIGMA,
        0);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "MIN_NU", "double",
        std::vector<size_t>{});
      MIN_NU = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 67;
      MIN_NU = context__.vals_r("MIN_NU")[(1 - 1)];
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "MIN_NU", MIN_NU, 1);
      current_statement__ = 68;
      context__.validate_dims("data initialization", "MAX_NU", "double",
        std::vector<size_t>{});
      MAX_NU = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 68;
      MAX_NU = context__.vals_r("MAX_NU")[(1 - 1)];
      current_statement__ = 68;
      stan::math::check_greater_or_equal(function__, "MAX_NU", MAX_NU, 1);
      current_statement__ = 69;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 69;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("y", "N", N);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "y", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      y_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&y) Eigen::Map<Eigen::Matrix<double,-1,1>>(y_data__.data(), N);
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 71;
        y_flat__ = context__.vals_r("y");
        current_statement__ = 71;
        pos__ = 1;
        current_statement__ = 71;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 71;
          stan::model::assign(y, y_flat__[(pos__ - 1)],
            "assigning variable y", stan::model::index_uni(sym1__));
          current_statement__ = 71;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "y", y, 0);
      current_statement__ = 72;
      context__.validate_dims("data initialization", "POW_TREND_ALPHA",
        "double", std::vector<size_t>{});
      POW_TREND_ALPHA = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 72;
      POW_TREND_ALPHA = context__.vals_r("POW_TREND_ALPHA")[(1 - 1)];
      current_statement__ = 72;
      stan::math::check_greater_or_equal(function__, "POW_TREND_ALPHA",
        POW_TREND_ALPHA, 0);
      current_statement__ = 73;
      context__.validate_dims("data initialization", "POW_TREND_BETA",
        "double", std::vector<size_t>{});
      POW_TREND_BETA = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 73;
      POW_TREND_BETA = context__.vals_r("POW_TREND_BETA")[(1 - 1)];
      current_statement__ = 73;
      stan::math::check_greater_or_equal(function__, "POW_TREND_BETA",
        POW_TREND_BETA, 0);
      current_statement__ = 74;
      context__.validate_dims("data initialization", "USE_REGRESSION", "int",
        std::vector<size_t>{});
      USE_REGRESSION = std::numeric_limits<int>::min();
      current_statement__ = 74;
      USE_REGRESSION = context__.vals_i("USE_REGRESSION")[(1 - 1)];
      current_statement__ = 74;
      stan::math::check_greater_or_equal(function__, "USE_REGRESSION",
        USE_REGRESSION, 0);
      current_statement__ = 74;
      stan::math::check_less_or_equal(function__, "USE_REGRESSION",
        USE_REGRESSION, 1);
      current_statement__ = 75;
      context__.validate_dims("data initialization", "USE_SMOOTHED_ERROR",
        "int", std::vector<size_t>{});
      USE_SMOOTHED_ERROR = std::numeric_limits<int>::min();
      current_statement__ = 75;
      USE_SMOOTHED_ERROR = context__.vals_i("USE_SMOOTHED_ERROR")[(1 - 1)];
      current_statement__ = 75;
      stan::math::check_greater_or_equal(function__, "USE_SMOOTHED_ERROR",
        USE_SMOOTHED_ERROR, 0);
      current_statement__ = 75;
      stan::math::check_less_or_equal(function__, "USE_SMOOTHED_ERROR",
        USE_SMOOTHED_ERROR, 1);
      current_statement__ = 76;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 76;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 76;
      stan::math::check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("xreg", "N", N);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("xreg", "J", J);
      current_statement__ = 79;
      context__.validate_dims("data initialization", "xreg", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(J)});
      xreg_data__ = Eigen::Matrix<double,-1,-1>::Constant(N, J,
                      std::numeric_limits<double>::quiet_NaN());
      new (&xreg) Eigen::Map<Eigen::Matrix<double,-1,-1>>(xreg_data__.data(),
        N, J);
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 79;
        xreg_flat__ = context__.vals_r("xreg");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 79;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 79;
            stan::model::assign(xreg, xreg_flat__[(pos__ - 1)],
              "assigning variable xreg", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 79;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 80;
      stan::math::validate_non_negative_index("REG_CAUCHY_SD", "J", J);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "REG_CAUCHY_SD",
        "double", std::vector<size_t>{static_cast<size_t>(J)});
      REG_CAUCHY_SD_data__ = Eigen::Matrix<double,-1,1>::Constant(J,
                               std::numeric_limits<double>::quiet_NaN());
      new (&REG_CAUCHY_SD)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(REG_CAUCHY_SD_data__.data(),
        J);
      {
        std::vector<local_scalar_t__> REG_CAUCHY_SD_flat__;
        current_statement__ = 81;
        REG_CAUCHY_SD_flat__ = context__.vals_r("REG_CAUCHY_SD");
        current_statement__ = 81;
        pos__ = 1;
        current_statement__ = 81;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 81;
          stan::model::assign(REG_CAUCHY_SD, REG_CAUCHY_SD_flat__[(pos__ -
            1)], "assigning variable REG_CAUCHY_SD",
            stan::model::index_uni(sym1__));
          current_statement__ = 81;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 81;
      stan::math::check_greater_or_equal(function__, "REG_CAUCHY_SD",
        REG_CAUCHY_SD, 0);
      current_statement__ = 82;
      reg0CauchySd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 82;
      reg0CauchySd = (stan::math::mean(REG_CAUCHY_SD) * 10);
      current_statement__ = 82;
      stan::math::check_greater_or_equal(function__, "reg0CauchySd",
        reg0CauchySd, 0);
      current_statement__ = 83;
      stan::math::validate_non_negative_index("regCoef", "J", J);
      current_statement__ = 84;
      stan::math::validate_non_negative_index("l", "N", N);
      current_statement__ = 85;
      stan::math::validate_non_negative_index("b", "N", N);
      current_statement__ = 86;
      stan::math::validate_non_negative_index("r", "N", N);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("expVal", "N", N);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("smoothedInnovSize", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = J + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1;
  }
  inline std::string model_name() const final {
    return "model_nostudent";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_nostudent_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,1> regCoef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 1;
      regCoef = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(J);
      local_scalar_t__ regOffset = DUMMY_VAR__;
      current_statement__ = 2;
      regOffset = in__.template read<local_scalar_t__>();
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 3;
      nu = in__.template read_constrain_lub<local_scalar_t__,
             jacobian__>(MIN_NU, MAX_NU, lp__);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 4;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      local_scalar_t__ levSm = DUMMY_VAR__;
      current_statement__ = 5;
      levSm = in__.template read_constrain_lub<local_scalar_t__,
                jacobian__>(0, 1, lp__);
      local_scalar_t__ bSm = DUMMY_VAR__;
      current_statement__ = 6;
      bSm = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(0,
              1, lp__);
      local_scalar_t__ powx = DUMMY_VAR__;
      current_statement__ = 7;
      powx = in__.template read_constrain_lub<local_scalar_t__,
               jacobian__>(0, 1, lp__);
      local_scalar_t__ bInit = DUMMY_VAR__;
      current_statement__ = 8;
      bInit = in__.template read<local_scalar_t__>();
      local_scalar_t__ powTrendBeta = DUMMY_VAR__;
      current_statement__ = 9;
      powTrendBeta = in__.template read_constrain_lub<local_scalar_t__,
                       jacobian__>(0, 1, lp__);
      local_scalar_t__ coefTrend = DUMMY_VAR__;
      current_statement__ = 10;
      coefTrend = in__.template read<local_scalar_t__>();
      local_scalar_t__ offsetSigma = DUMMY_VAR__;
      current_statement__ = 11;
      offsetSigma = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(MIN_SIGMA, lp__);
      local_scalar_t__ locTrendFract = DUMMY_VAR__;
      current_statement__ = 12;
      locTrendFract = in__.template read_constrain_lub<local_scalar_t__,
                        jacobian__>(0, 1, lp__);
      local_scalar_t__ innovSm = DUMMY_VAR__;
      current_statement__ = 13;
      innovSm = in__.template read_constrain_lub<local_scalar_t__,
                  jacobian__>(0, 1, lp__);
      local_scalar_t__ innovSizeInit = DUMMY_VAR__;
      current_statement__ = 14;
      innovSizeInit = in__.template read_constrain_lb<local_scalar_t__,
                        jacobian__>(0, lp__);
      local_scalar_t__ powTrend = DUMMY_VAR__;
      Eigen::Matrix<local_scalar_t__,-1,1> l =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> r =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> expVal =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> smoothedInnovSize =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 23;
      if (USE_REGRESSION) {
        current_statement__ = 22;
        stan::model::assign(r,
          stan::math::add(stan::math::multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 21;
        stan::model::assign(r, stan::math::rep_vector(0, N),
          "assigning variable r");
      }
      current_statement__ = 26;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 25;
        stan::model::assign(smoothedInnovSize, innovSizeInit,
          "assigning variable smoothedInnovSize", stan::model::index_uni(1));
      } else {
        current_statement__ = 24;
        stan::model::assign(smoothedInnovSize, 1,
          "assigning variable smoothedInnovSize", stan::model::index_uni(1));
      }
      current_statement__ = 27;
      stan::model::assign(l,
        (stan::model::rvalue(y, "y", stan::model::index_uni(1)) -
        stan::model::rvalue(r, "r", stan::model::index_uni(1))),
        "assigning variable l", stan::model::index_uni(1));
      current_statement__ = 28;
      stan::model::assign(b, bInit, "assigning variable b",
        stan::model::index_uni(1));
      current_statement__ = 29;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
        MIN_POW_TREND);
      current_statement__ = 30;
      stan::model::assign(expVal,
        stan::model::rvalue(y, "y", stan::model::index_uni(1)),
        "assigning variable expVal", stan::model::index_uni(1));
      current_statement__ = 38;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 31;
        stan::model::assign(expVal,
          (((stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))) +
          (coefTrend *
          stan::math::pow(
            stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))),
            powTrend))) + (locTrendFract *
          stan::model::rvalue(b, "b", stan::model::index_uni((t - 1))))) +
          stan::model::rvalue(r, "r", stan::model::index_uni(t))),
          "assigning variable expVal", stan::model::index_uni(t));
        current_statement__ = 32;
        stan::model::assign(l, ((levSm *
          (stan::model::rvalue(y, "y", stan::model::index_uni(t)) -
          stan::model::rvalue(r, "r", stan::model::index_uni(t)))) + ((1 -
          levSm) *
          stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))))),
          "assigning variable l", stan::model::index_uni(t));
        current_statement__ = 33;
        stan::model::assign(b, ((bSm *
          (stan::model::rvalue(l, "l", stan::model::index_uni(t)) -
          stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))))) +
          (((1 - bSm) * locTrendFract) *
          stan::model::rvalue(b, "b", stan::model::index_uni((t - 1))))),
          "assigning variable b", stan::model::index_uni(t));
        current_statement__ = 36;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 35;
          stan::model::assign(smoothedInnovSize, ((innovSm *
            stan::math::abs(
              (stan::model::rvalue(y, "y", stan::model::index_uni(t)) -
              stan::model::rvalue(expVal, "expVal", stan::model::index_uni(t)))))
            + ((1 - innovSm) *
            stan::model::rvalue(smoothedInnovSize, "smoothedInnovSize",
              stan::model::index_uni((t - 1))))),
            "assigning variable smoothedInnovSize", stan::model::index_uni(t));
        } else {
          current_statement__ = 34;
          stan::model::assign(smoothedInnovSize, 1,
            "assigning variable smoothedInnovSize", stan::model::index_uni(t));
        }
      }
      current_statement__ = 15;
      stan::math::check_greater_or_equal(function__, "powTrend", powTrend,
        MIN_POW_TREND);
      current_statement__ = 15;
      stan::math::check_less_or_equal(function__, "powTrend", powTrend,
        MAX_POW_TREND);
      current_statement__ = 16;
      stan::math::check_greater_or_equal(function__, "l", l, 0);
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "expVal", expVal, 0);
      current_statement__ = 20;
      stan::math::check_greater_or_equal(function__, "smoothedInnovSize",
        smoothedInnovSize, 0);
      {
        current_statement__ = 39;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(sigma, 0, CAUCHY_SD));
        current_statement__ = 40;
        if (stan::math::logical_lt(sigma, 0)) {
          current_statement__ = 40;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 40;
          lp_accum__.add(-stan::math::cauchy_lccdf(0, 0, CAUCHY_SD));
        }
        current_statement__ = 41;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(offsetSigma,
                         MIN_SIGMA, CAUCHY_SD));
        current_statement__ = 42;
        if (stan::math::logical_lt(offsetSigma, MIN_SIGMA)) {
          current_statement__ = 42;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 42;
          lp_accum__.add(-stan::math::cauchy_lccdf(MIN_SIGMA, MIN_SIGMA,
                            CAUCHY_SD));
        }
        current_statement__ = 43;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(coefTrend, 0,
                         CAUCHY_SD));
        current_statement__ = 44;
        lp_accum__.add(stan::math::beta_lpdf<propto__>(powTrendBeta,
                         POW_TREND_ALPHA, POW_TREND_BETA));
        current_statement__ = 47;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 48;
          lp_accum__.add(stan::math::cauchy_lpdf<propto__>(innovSizeInit,
                           (stan::model::rvalue(y, "y",
                              stan::model::index_uni(1)) / 100), CAUCHY_SD));
          current_statement__ = 49;
          if (stan::math::logical_lt(innovSizeInit, 0)) {
            current_statement__ = 49;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 49;
            lp_accum__.add(-stan::math::cauchy_lccdf(0,
                              (stan::model::rvalue(y, "y",
                                 stan::model::index_uni(1)) / 100), CAUCHY_SD));
          }
        } else {
          current_statement__ = 45;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(innovSizeInit, 0,
                           1));
          current_statement__ = 46;
          if (stan::math::logical_lt(innovSizeInit, 0)) {
            current_statement__ = 46;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 46;
            lp_accum__.add(-stan::math::normal_lccdf(0, 0, 1));
          }
        }
        current_statement__ = 56;
        if (USE_REGRESSION) {
          current_statement__ = 53;
          lp_accum__.add(stan::math::cauchy_lpdf<propto__>(regCoef, 0,
                           REG_CAUCHY_SD));
          current_statement__ = 54;
          lp_accum__.add(stan::math::cauchy_lpdf<propto__>(regOffset, 0,
                           reg0CauchySd));
        } else {
          current_statement__ = 50;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(regCoef, 0, 1));
          current_statement__ = 51;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(regOffset, 0, 1));
        }
        current_statement__ = 57;
        lp_accum__.add(stan::math::cauchy_lpdf<propto__>(bInit, 0, CAUCHY_SD));
        current_statement__ = 62;
        for (int t = 2; t <= N; ++t) {
          current_statement__ = 60;
          if (stan::math::logical_eq(USE_SMOOTHED_ERROR, 0)) {
            current_statement__ = 59;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(
                             stan::model::rvalue(y, "y",
                               stan::model::index_uni(t)),
                             stan::model::rvalue(expVal, "expVal",
                               stan::model::index_uni(t)), ((sigma *
                             stan::math::pow(
                               stan::model::rvalue(expVal, "expVal",
                                 stan::model::index_uni(t)), powx)) +
                             offsetSigma)));
          } else {
            current_statement__ = 58;
            lp_accum__.add(stan::math::normal_lpdf<propto__>(
                             stan::model::rvalue(y, "y",
                               stan::model::index_uni(t)),
                             stan::model::rvalue(expVal, "expVal",
                               stan::model::index_uni(t)), ((sigma *
                             stan::model::rvalue(smoothedInnovSize,
                               "smoothedInnovSize",
                               stan::model::index_uni((t - 1)))) +
                             offsetSigma)));
          }
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_nostudent_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,1> regCoef =
        Eigen::Matrix<double,-1,1>::Constant(J,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      regCoef = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(J);
      double regOffset = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      regOffset = in__.template read<local_scalar_t__>();
      double nu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      nu = in__.template read_constrain_lub<local_scalar_t__,
             jacobian__>(MIN_NU, MAX_NU, lp__);
      double sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      double levSm = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 5;
      levSm = in__.template read_constrain_lub<local_scalar_t__,
                jacobian__>(0, 1, lp__);
      double bSm = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 6;
      bSm = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(0,
              1, lp__);
      double powx = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 7;
      powx = in__.template read_constrain_lub<local_scalar_t__,
               jacobian__>(0, 1, lp__);
      double bInit = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 8;
      bInit = in__.template read<local_scalar_t__>();
      double powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 9;
      powTrendBeta = in__.template read_constrain_lub<local_scalar_t__,
                       jacobian__>(0, 1, lp__);
      double coefTrend = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 10;
      coefTrend = in__.template read<local_scalar_t__>();
      double offsetSigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 11;
      offsetSigma = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(MIN_SIGMA, lp__);
      double locTrendFract = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 12;
      locTrendFract = in__.template read_constrain_lub<local_scalar_t__,
                        jacobian__>(0, 1, lp__);
      double innovSm = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 13;
      innovSm = in__.template read_constrain_lub<local_scalar_t__,
                  jacobian__>(0, 1, lp__);
      double innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 14;
      innovSizeInit = in__.template read_constrain_lb<local_scalar_t__,
                        jacobian__>(0, lp__);
      double powTrend = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,1> l =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> b =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> r =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> expVal =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> smoothedInnovSize =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(regCoef);
      out__.write(regOffset);
      out__.write(nu);
      out__.write(sigma);
      out__.write(levSm);
      out__.write(bSm);
      out__.write(powx);
      out__.write(bInit);
      out__.write(powTrendBeta);
      out__.write(coefTrend);
      out__.write(offsetSigma);
      out__.write(locTrendFract);
      out__.write(innovSm);
      out__.write(innovSizeInit);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 23;
      if (USE_REGRESSION) {
        current_statement__ = 22;
        stan::model::assign(r,
          stan::math::add(stan::math::multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 21;
        stan::model::assign(r, stan::math::rep_vector(0, N),
          "assigning variable r");
      }
      current_statement__ = 26;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 25;
        stan::model::assign(smoothedInnovSize, innovSizeInit,
          "assigning variable smoothedInnovSize", stan::model::index_uni(1));
      } else {
        current_statement__ = 24;
        stan::model::assign(smoothedInnovSize, 1,
          "assigning variable smoothedInnovSize", stan::model::index_uni(1));
      }
      current_statement__ = 27;
      stan::model::assign(l,
        (stan::model::rvalue(y, "y", stan::model::index_uni(1)) -
        stan::model::rvalue(r, "r", stan::model::index_uni(1))),
        "assigning variable l", stan::model::index_uni(1));
      current_statement__ = 28;
      stan::model::assign(b, bInit, "assigning variable b",
        stan::model::index_uni(1));
      current_statement__ = 29;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
        MIN_POW_TREND);
      current_statement__ = 30;
      stan::model::assign(expVal,
        stan::model::rvalue(y, "y", stan::model::index_uni(1)),
        "assigning variable expVal", stan::model::index_uni(1));
      current_statement__ = 38;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 31;
        stan::model::assign(expVal,
          (((stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))) +
          (coefTrend *
          stan::math::pow(
            stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))),
            powTrend))) + (locTrendFract *
          stan::model::rvalue(b, "b", stan::model::index_uni((t - 1))))) +
          stan::model::rvalue(r, "r", stan::model::index_uni(t))),
          "assigning variable expVal", stan::model::index_uni(t));
        current_statement__ = 32;
        stan::model::assign(l, ((levSm *
          (stan::model::rvalue(y, "y", stan::model::index_uni(t)) -
          stan::model::rvalue(r, "r", stan::model::index_uni(t)))) + ((1 -
          levSm) *
          stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))))),
          "assigning variable l", stan::model::index_uni(t));
        current_statement__ = 33;
        stan::model::assign(b, ((bSm *
          (stan::model::rvalue(l, "l", stan::model::index_uni(t)) -
          stan::model::rvalue(l, "l", stan::model::index_uni((t - 1))))) +
          (((1 - bSm) * locTrendFract) *
          stan::model::rvalue(b, "b", stan::model::index_uni((t - 1))))),
          "assigning variable b", stan::model::index_uni(t));
        current_statement__ = 36;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 35;
          stan::model::assign(smoothedInnovSize, ((innovSm *
            stan::math::abs(
              (stan::model::rvalue(y, "y", stan::model::index_uni(t)) -
              stan::model::rvalue(expVal, "expVal", stan::model::index_uni(t)))))
            + ((1 - innovSm) *
            stan::model::rvalue(smoothedInnovSize, "smoothedInnovSize",
              stan::model::index_uni((t - 1))))),
            "assigning variable smoothedInnovSize", stan::model::index_uni(t));
        } else {
          current_statement__ = 34;
          stan::model::assign(smoothedInnovSize, 1,
            "assigning variable smoothedInnovSize", stan::model::index_uni(t));
        }
      }
      current_statement__ = 15;
      stan::math::check_greater_or_equal(function__, "powTrend", powTrend,
        MIN_POW_TREND);
      current_statement__ = 15;
      stan::math::check_less_or_equal(function__, "powTrend", powTrend,
        MAX_POW_TREND);
      current_statement__ = 16;
      stan::math::check_greater_or_equal(function__, "l", l, 0);
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "expVal", expVal, 0);
      current_statement__ = 20;
      stan::math::check_greater_or_equal(function__, "smoothedInnovSize",
        smoothedInnovSize, 0);
      if (emit_transformed_parameters__) {
        out__.write(powTrend);
        out__.write(l);
        out__.write(b);
        out__.write(r);
        out__.write(expVal);
        out__.write(smoothedInnovSize);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> regCoef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(regCoef,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(J),
        "assigning variable regCoef");
      out__.write(regCoef);
      local_scalar_t__ regOffset = DUMMY_VAR__;
      current_statement__ = 2;
      regOffset = in__.read<local_scalar_t__>();
      out__.write(regOffset);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 3;
      nu = in__.read<local_scalar_t__>();
      out__.write_free_lub(MIN_NU, MAX_NU, nu);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 4;
      sigma = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma);
      local_scalar_t__ levSm = DUMMY_VAR__;
      current_statement__ = 5;
      levSm = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, levSm);
      local_scalar_t__ bSm = DUMMY_VAR__;
      current_statement__ = 6;
      bSm = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, bSm);
      local_scalar_t__ powx = DUMMY_VAR__;
      current_statement__ = 7;
      powx = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, powx);
      local_scalar_t__ bInit = DUMMY_VAR__;
      current_statement__ = 8;
      bInit = in__.read<local_scalar_t__>();
      out__.write(bInit);
      local_scalar_t__ powTrendBeta = DUMMY_VAR__;
      current_statement__ = 9;
      powTrendBeta = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, powTrendBeta);
      local_scalar_t__ coefTrend = DUMMY_VAR__;
      current_statement__ = 10;
      coefTrend = in__.read<local_scalar_t__>();
      out__.write(coefTrend);
      local_scalar_t__ offsetSigma = DUMMY_VAR__;
      current_statement__ = 11;
      offsetSigma = in__.read<local_scalar_t__>();
      out__.write_free_lb(MIN_SIGMA, offsetSigma);
      local_scalar_t__ locTrendFract = DUMMY_VAR__;
      current_statement__ = 12;
      locTrendFract = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, locTrendFract);
      local_scalar_t__ innovSm = DUMMY_VAR__;
      current_statement__ = 13;
      innovSm = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 1, innovSm);
      local_scalar_t__ innovSizeInit = DUMMY_VAR__;
      current_statement__ = 14;
      innovSizeInit = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, innovSizeInit);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "regCoef",
        "double", std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "regOffset",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "nu", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "levSm", "double",
        std::vector<size_t>{});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "bSm", "double",
        std::vector<size_t>{});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "powx", "double",
        std::vector<size_t>{});
      current_statement__ = 8;
      context__.validate_dims("parameter initialization", "bInit", "double",
        std::vector<size_t>{});
      current_statement__ = 9;
      context__.validate_dims("parameter initialization", "powTrendBeta",
        "double", std::vector<size_t>{});
      current_statement__ = 10;
      context__.validate_dims("parameter initialization", "coefTrend",
        "double", std::vector<size_t>{});
      current_statement__ = 11;
      context__.validate_dims("parameter initialization", "offsetSigma",
        "double", std::vector<size_t>{});
      current_statement__ = 12;
      context__.validate_dims("parameter initialization", "locTrendFract",
        "double", std::vector<size_t>{});
      current_statement__ = 13;
      context__.validate_dims("parameter initialization", "innovSm",
        "double", std::vector<size_t>{});
      current_statement__ = 14;
      context__.validate_dims("parameter initialization", "innovSizeInit",
        "double", std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,1> regCoef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> regCoef_flat__;
        current_statement__ = 1;
        regCoef_flat__ = context__.vals_r("regCoef");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 1;
          stan::model::assign(regCoef, regCoef_flat__[(pos__ - 1)],
            "assigning variable regCoef", stan::model::index_uni(sym1__));
          current_statement__ = 1;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(regCoef);
      local_scalar_t__ regOffset = DUMMY_VAR__;
      current_statement__ = 2;
      regOffset = context__.vals_r("regOffset")[(1 - 1)];
      out__.write(regOffset);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 3;
      nu = context__.vals_r("nu")[(1 - 1)];
      out__.write_free_lub(MIN_NU, MAX_NU, nu);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 4;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      out__.write_free_lb(0, sigma);
      local_scalar_t__ levSm = DUMMY_VAR__;
      current_statement__ = 5;
      levSm = context__.vals_r("levSm")[(1 - 1)];
      out__.write_free_lub(0, 1, levSm);
      local_scalar_t__ bSm = DUMMY_VAR__;
      current_statement__ = 6;
      bSm = context__.vals_r("bSm")[(1 - 1)];
      out__.write_free_lub(0, 1, bSm);
      local_scalar_t__ powx = DUMMY_VAR__;
      current_statement__ = 7;
      powx = context__.vals_r("powx")[(1 - 1)];
      out__.write_free_lub(0, 1, powx);
      local_scalar_t__ bInit = DUMMY_VAR__;
      current_statement__ = 8;
      bInit = context__.vals_r("bInit")[(1 - 1)];
      out__.write(bInit);
      local_scalar_t__ powTrendBeta = DUMMY_VAR__;
      current_statement__ = 9;
      powTrendBeta = context__.vals_r("powTrendBeta")[(1 - 1)];
      out__.write_free_lub(0, 1, powTrendBeta);
      local_scalar_t__ coefTrend = DUMMY_VAR__;
      current_statement__ = 10;
      coefTrend = context__.vals_r("coefTrend")[(1 - 1)];
      out__.write(coefTrend);
      local_scalar_t__ offsetSigma = DUMMY_VAR__;
      current_statement__ = 11;
      offsetSigma = context__.vals_r("offsetSigma")[(1 - 1)];
      out__.write_free_lb(MIN_SIGMA, offsetSigma);
      local_scalar_t__ locTrendFract = DUMMY_VAR__;
      current_statement__ = 12;
      locTrendFract = context__.vals_r("locTrendFract")[(1 - 1)];
      out__.write_free_lub(0, 1, locTrendFract);
      local_scalar_t__ innovSm = DUMMY_VAR__;
      current_statement__ = 13;
      innovSm = context__.vals_r("innovSm")[(1 - 1)];
      out__.write_free_lub(0, 1, innovSm);
      local_scalar_t__ innovSizeInit = DUMMY_VAR__;
      current_statement__ = 14;
      innovSizeInit = context__.vals_r("innovSizeInit")[(1 - 1)];
      out__.write_free_lb(0, innovSizeInit);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"regCoef", "regOffset", "nu", "sigma",
                "levSm", "bSm", "powx", "bInit", "powTrendBeta", "coefTrend",
                "offsetSigma", "locTrendFract", "innovSm", "innovSizeInit"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"powTrend", "l", "b", "r", "expVal", "smoothedInnovSize"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(J)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "regCoef" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "bSm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "bInit");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "locTrendFract");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "l" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "r" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "expVal" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.'
          + std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "regCoef" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "bSm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "bInit");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "locTrendFract");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "l" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "b" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "r" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "expVal" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.'
          + std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"locTrendFract\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"locTrendFract\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((((((((((J + 1) + 1) + 1) + 1) + 1) + 1)
      + 1) + 1) + 1) + 1) + 1) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((((1 + N)
      + N) + N) + N) + N));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((((((((((J + 1) + 1) + 1) + 1) + 1) + 1)
      + 1) + 1) + 1) + 1) + 1) + 1) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((((1 + N)
      + N) + N) + N) + N));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_nostudent_namespace::model_nostudent;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_nostudent_namespace::profiles__;
}
#endif
#endif
