% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{pkgOptions}
\alias{pkgOptions}
\title{Set or get options for the Rnightlights package}
\usage{
pkgOptions(...)
}
\arguments{
\item{...}{Option names to retrieve option values or \code{[key]=[value]} pairs to set options.}
}
\value{
if an option name is supplied as a parameter this returns the value, else a list of all options is returned.
}
\description{
Set or get options for the Rnightlights package
}
\section{Supported options}{

The following options are supported
\itemize{
 \item{\code{dirNlTiles}}{(\code{character}) The directory in which to store the downloaded VIIRS raster tiles }
 \item{\code{dirRasterOutput}}{(\code{character}) The directory in which to store the clipped country rasters }
 \item{\code{dirRasterWeb}}{(\code{character}) The directory in which to store the rasters resampled for web display }
 \item{\code{dirZonals}}{(\code{character}) The directory in which to store the zonal statistics country polygon }
 \item{\code{dirPolygon}}{(\code{character}) The directory to store the downloaded country administration level polygons }
 \item{\code{dirNlData}}{(\code{character}) The directory to store the extracted data files in }
 \item{\code{cropMaskMethod}}{(\code{character}) The method to use to clip the nightlight raster tiles to the country boundaries }
 \item{\code{extractMethod}}{(\code{character}) The method to use to extract data from the rasters }
 \item{\code{downloadMethod}}{(\code{character}) The download method to use }
 \item{\code{omitCountries}}{(\code{character}) The countries to exclude in processing }
}
}

\examples{
#retrieve the current cropMaskMethod
pkgOptions("cropMaskMethod")

#set the cropMaskMethod
pkgOptions(cropMaskMethod="gdal")

#retrieve all options
pkgOptions()

}
