% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrynldata.R
\name{getCtryNlData}
\alias{getCtryNlData}
\title{Returns nightlight statistics for the given ctryCode and nlType in the given nPeriods}
\usage{
getCtryNlData(ctryCode, nlPeriods, nlType, stats = pkgOptions("stats"),
  ignoreMissing = NULL, source = "local")
}
\arguments{
\item{ctryCode}{the ISO3 code of the country. Only 1 country can be 
processed at a time}

\item{nlPeriods}{a vector of nlPeriods. Must be appropriate nlPeriods
for the nlType.}

\item{nlType}{the nightlight type i.e. "OLS" or "VIIRS" (default)}

\item{stats}{a vector of stats. if not supplied defaults to all stats
as listed in pkgOptions("stats")}

\item{ignoreMissing}{controls how the function behaves if any data is not
found in the data file

\itemize{
    \item NULL (default) only return data if found for ALL nlPeriods
       and ALL stats provided otherwise return NULL
    \item TRUE return any partial data that is found for the provided 
       nlPeriods and stats. Ignore any missing data
    \item FALSE return all data that is found and call \code{processNlData}
       to download and process any missing nlPeriods and stats
}}

\item{source}{"local" or "remote" Whether to download and process the
data locally or to download the pre-processed data from a remote 
source/repo}
}
\value{
dataframe of data for one country in one nlType in one or multiple
    nlPeriods
}
\description{
Returns nightlight data for the given ctryCode and stats in the given 
    nlPeriods and of the specified nlType. Note that getCtryNldata only
    processes one ctryCode at a time.
    \code{ignoreMissing} plays a significant role here. It can take 3 values:
    
    \itemize{
        \item NULL (default) only return data if found for all nlPeriods
           and all stats provided otherwise return NULL.
        \item TRUE return any partial data that is found for the provided 
           nlPeriods and stats. Ignore any missing data.
        \item FALSE return all data that is found and call \code{processNlData}
           to download and process any missing nlPeriods and stats.
    }
   
   Farther, if \code{nlPeriods} is missing, it is assigned values based on
   the value of ignoreMissing. If ignoreMissing is FALSE, nlPeriods is 
   assigned all existing nlPeriods to date. This is the equivalent of 
   retrieving all nightlight data for the given country and stats. If 
   ignoreMissing is TRUE or NULL then the existing data is returned.
}
\examples{
#missing stats implies all stats as given by pkgOptions("stats")

\dontrun{getCtryNlData("KEN", nlType="VIIRS", ignoreMissing=NULL)}
    #returns all existing data i.e. all nlPeriods and all stats for KEN

\dontrun{getCtryNlData("KEN", ignoreMissing=TRUE)}
    #same as ignoreMissing=NULL. Returns all existing data i.e. all nlPeriods
    #and all stats for KEN
 
\dontrun{getCtryNlData(ctryCode="KEN", nlType="VIIRS", ignoreMissing=FALSE)}
    #for any missing data between 201401 to present download and process the
    #data then return all data
 
\dontrun{getCtryNlData("KEN", nlPeriod=c("existingNlPeriod", "missingNlPeriod"),
    stats=c("sum", "unknownStat"), ignoreMissing=NULL)}
    #Returns NULL
    #(ignoreMissing=NULL returns all data if exists or if any is missing returns NULL)

\dontrun{getCtryNlData("KEN", nlPeriods=c("existingNlPeriod", "missingNlPeriod"),
    stats=c("existingStat", "missingStat"), ignoreMissing=TRUE)}
   #Returns existingStat for existingNlPeriods
   #(ignoreMissing=TRUE returns only existing data)
 
\dontrun{getCtryNlData("KEN", nlYearPeriods=c("existingNlPeriod", "missingNlPeriod"),
    stats=c("sum", "unknownStat"), ignoreMissing=FALSE)}
    #Runs processNlData for missingStat in "missingNlPeriod" and returns
    #"existingStat" and "missingStat" for both "existingNlPeriod" and
    #"missingNlPeriod"
    #(ignoreMissing=FALSE must return all data: forces processing of any missing)
 
}
