% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiles.R
\name{tilesPolygonIntersectVIIRS}
\alias{tilesPolygonIntersectVIIRS}
\title{Get the list of VIIRS tiles that a polygon intersects with}
\usage{
tilesPolygonIntersectVIIRS(shpPolygon)
}
\arguments{
\item{shpPolygon}{a SpatialPolygon or SpatialPolygons}
}
\value{
Character vector of the intersecting tiles as given by \code{getNlTiles}
}
\description{
Get the list a VIIRS tiles that a polygon intersects with
}
\examples{
\dontrun{
#download shapefile if it doesn't exist
ctryShapefile <- Rnightlights:::dnldCtryPoly("KEN")

#read in shapefile top layer
ctryPoly <- readCtryPolyAdmLayer("KEN", 
    Rnightlights:::getCtryShpLyrNames("KEN",0))

#get list of intersecting tiles
tileList <- Rnightlights:::tilesPolygonIntersectVIIRS(ctryPoly)
}

}
