% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nightlights.R
\name{getCtryRasterOutputFname}
\alias{getCtryRasterOutputFname}
\title{Constructs the name of the output raster}
\usage{
getCtryRasterOutputFname(ctryCode, nlType,
  configName = pkgOptions(paste0("configName_", nlType)),
  multiTileStrategy = pkgOptions("multiTileStrategy"),
  multiTileMergeFun = pkgOptions("multiTileMergeFun"),
  removeGasFlares = pkgOptions("removeGasFlares"), nlPeriod,
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCode}{the ctryCode of interest}

\item{nlType}{the nlType of interest}

\item{configName}{character the type of raster being processed}

\item{multiTileStrategy}{character How to handle multiple tiles per nlPeriod}

\item{multiTileMergeFun}{character The function to use to merge tiles}

\item{removeGasFlares}{logical Whether to perform gas flare removal pre-processing}

\item{nlPeriod}{the nlPeriod of interest}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{The path to a custom polygon as an alternative
to using GADM polygons}
}
\value{
Character the name of country raster for a country and a given 
    nlType and nlPeriod
}
\description{
Constructs the name of the output raster
}
\examples{

Rnightlights:::getCtryRasterOutputFname(ctryCode = "KEN", nlType = "VIIRS.M", nlPeriod = "201412")

}
