% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnlfilename.R
\name{getNlTileTifLclNamePathVIIRS}
\alias{getNlTileTifLclNamePathVIIRS}
\title{Constructs the full path used to save/access the decompressed VIIRS .tif file}
\usage{
getNlTileTifLclNamePathVIIRS(nlType = "VIIRS.M",
  configName = pkgOptions(paste0("configName_", nlType)), nlPeriod,
  tileNum)
}
\arguments{
\item{nlType}{The particular VIIRS type e.g. VIIRS.D for daily VIIRS}

\item{configName}{character the type of raster being processed}

\item{nlPeriod}{the yearMonth in which the tile was created}

\item{tileNum}{the index of the tile as given in nlTileIndex}
}
\value{
a character vector filename of the .tif VIIRS tile
}
\description{
Constructs the full path used to save/access the decompressed VIIRS .tif file
}
\examples{
#using default dirNlTiles
\dontrun{
Rnightlights:::getNlTileTifLclNamePathVIIRS(nlType = "VIIRS.M", nlPeriod = "201401", tileNum = "1")
 #returns "/dataPath/tiles/VIIRS_2014_01_75N180W.tif"
 }

}
