% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrycode.R
\name{searchCountry}
\alias{searchCountry}
\title{Search for a country by name or code}
\usage{
searchCountry(searchTerms, extended = FALSE)
}
\arguments{
\item{searchTerms}{The country code/name to search for}

\item{extended}{Whether to do partial searches}
}
\value{
data.frame A mapping of the ctryCode to ctryName if the supplied
    \code{searchTerm} is a ctryCode or vice-versa if the \code{searchTerm}
    was a ctryName
}
\description{
Serves as a frontend to the ctryNameToCode and ctryCodeToName functions
    in one.
}
\examples{
searchCountry("KEN") #returns Kenya

searchCountry("Tanzania") #returns United Republic of Tanzania

searchCountry("uk", TRUE) #returns United Kingdom and Ukraine

searchCountry("rwa", TRUE) #returns Rwanda and Norway

}
