% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{plot.RoBMA.prior}
\alias{plot.RoBMA.prior}
\title{Plots a RoBMA.prior object}
\usage{
\method{plot}{RoBMA.prior}(
  x,
  plot_type = "base",
  effect_size = NULL,
  mu_transform = NULL,
  show_figures = -1,
  weights = FALSE,
  par_name = "mu",
  samples = 1e+06,
  points = 1000,
  ...
)
}
\arguments{
\item{x}{a RoBMA prior}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot2"} for plotting. The later
requires \pkg{ggplot2} package to be installed.}

\item{effect_size}{type of effect size which is supposed to
be plotted. Only relevant if the mu parameter needs to be
transformed (\code{"r"} for correlation coefficients or \code{"OR"}
for odds ratios).}

\item{mu_transform}{whether and how should the prior distribution
be transformed. If the prior distribution is constructed for
effect sizes supplied as correlations, the prior for mu parameter
is not defined on the correlation scale directly, but transformed into
it. Only possible if the \code{effect_size == "r"} or
\code{effect_size == "OR"} and \code{par_name = "mu"}.
Defaults to \code{NULL}. Other options are \code{"cohens_d"},
\code{"fishers_z"}, and \code{"log_OR"}.}

\item{show_figures}{which figures should be returned in case of
multiple plots are generated. Useful when priors for the omega
parameter are plotted and \code{weights = TRUE}.}

\item{weights}{whether the weights or weight function should
be returned. Only applicable for priors on the omega parameter.
Defaults to \code{FALSE} - the weight function is plotted.}

\item{par_name}{a type of parameter for which the prior is
specified. Only relevant if the prior corresponds to a mu
parameter that needs to be transformed.}

\item{samples}{how many samples should be drawn for the
density plot (applies only for the weight functions, other
prior distributions are plotted using the pdf). Defaults
to \code{10000}.}

\item{points}{how many points should be used for drawing the
density plot. Defaults to \code{1000}.}

\item{...}{additional arguments}
}
\description{
Plots a RoBMA.prior object
}
\seealso{
\code{\link[=prior]{prior()}}
}
