% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\alias{diagnostics_autocorrelation}
\alias{diagnostics_trace}
\alias{diagnostics_density}
\title{Checks a fitted RoBTT object}
\usage{
diagnostics(
  fit,
  parameter,
  type,
  show_models = NULL,
  lags = 30,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)

diagnostics_autocorrelation(
  fit,
  parameter = NULL,
  show_models = NULL,
  lags = 30,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)

diagnostics_trace(
  fit,
  parameter = NULL,
  show_models = NULL,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)

diagnostics_density(
  fit,
  parameter = NULL,
  show_models = NULL,
  title = is.null(show_models) | length(show_models) > 1,
  ...
)
}
\arguments{
\item{fit}{a fitted RoBTT object}

\item{parameter}{a parameter to be plotted. Either
\code{"delta"}, \code{"rho"}, \code{"nu"}, \code{"mu"},
or \code{"sigma"}.}

\item{type}{type of MCMC diagnostic to be plotted.
Options are \code{"chains"} for the chains' trace plots,
\code{"autocorrelation"} for autocorrelation of the
chains, and \code{"densities"} for the overlaying
densities of the individual chains. Can be abbreviated to
first letters.}

\item{show_models}{MCMC diagnostics of which models should be
plotted. Defaults to \code{NULL} which plots MCMC diagnostics
for a specified parameter for every model that is part of the
ensemble.}

\item{lags}{number of lags to be shown for
\code{type = "autocorrelation"}. Defaults to \code{30}.}

\item{title}{whether the model number should be displayed in title.
Defaults to \code{TRUE} when more than one model is selected.}

\item{...}{additional arguments to be passed to
\link[graphics]{par} if \code{plot_type = "base"}.}
}
\value{
\code{diagnostics} returns either \code{NULL} if \code{plot_type = "base"}
or an object/list of objects (depending on the number of parameters to be plotted)
of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
\code{diagnostics} creates visual
checks of individual models convergence. Numerical
overview of individual models can be obtained by
\code{summary(object, type = "models", diagnostics = TRUE)},
or even more detailed information by
\code{summary(object, type = "individual")}.
}
\details{
The visualization functions are based on
\link[rstan]{stan_plot} function and its color schemes.
}
\examples{
\dontrun{
# using the example data from Darwin
data("fertilization", package = "RoBTT")
fit <- RoBTT(
  x1       = fertilization$Self,
  x2       = fertilization$Crossed,
  prior_delta = prior("cauchy", list(0, 1/sqrt(2))),
  prior_rho   = prior("beta",   list(3, 3)),
  seed        = 1, 
  chains      = 1,
  warmup      = 1000,
  iter        = 2000,
  control     = set_control(adapt_delta = 0.95)
)

### ggplot2 version of all of the plots can be obtained by adding 'model_type = "ggplot"
# diagnostics function allows to visualize diagnostics of a fitted RoBTT object, for example,
# the trace plot for the mean parameter in each model model
diagnostics(fit, parameter = "delta", type = "chain")

# in order to show the trace plot only for the 11th model, add show_models parameter
diagnostics(fit, parameter = "delta", type = "chain", show_models = 11)

# furthermore, the autocorrelations
diagnostics(fit, parameter = "delta", type = "autocorrelation")

# and overlying densities for each plot can also be visualize
diagnostics(fit, parameter = "delta", type = "densities")
}


}
\seealso{
\code{\link[=RoBTT]{RoBTT()}}, \code{\link[=summary.RoBTT]{summary.RoBTT()}}
}
