% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{update.RoBTT}
\alias{update.RoBTT}
\title{Updates a fitted RoBTT object}
\usage{
\method{update}{RoBTT}(
  object,
  refit_failed = TRUE,
  prior_weights = NULL,
  chains = NULL,
  iter = NULL,
  warmup = NULL,
  thin = NULL,
  parallel = NULL,
  control = NULL,
  convergence_checks = NULL,
  save = "all",
  seed = NULL,
  silent = TRUE,
  ...
)
}
\arguments{
\item{object}{a fitted RoBTT object}

\item{refit_failed}{whether failed models should be refitted. Relevant only
\code{prior_weights} are not supplied. Defaults to \code{TRUE}.}

\item{prior_weights}{either a single value specifying prior model weight
of a newly specified model using priors argument, or a vector of the
same length as already fitted models to update their prior weights.}

\item{chains}{a number of chains of the MCMC algorithm.}

\item{iter}{a number of sampling iterations of the MCMC algorithm.
Defaults to \code{10000}, with a minimum of \code{4000}.}

\item{warmup}{a number of warmup  iterations of the MCMC algorithm.
Defaults to \code{5000}.}

\item{thin}{a thinning of the chains of the MCMC algorithm. Defaults to
\code{1}.}

\item{parallel}{whether the individual models should be fitted in parallel.
Defaults to \code{FALSE}. The implementation is not completely stable
and might cause a connection error.}

\item{control}{allows to pass control settings with the
\code{\link[=set_control]{set_control()}} function. See \code{?set_control} for
options and default settings.}

\item{convergence_checks}{automatic convergence checks to assess the fitted
models, passed with \code{\link[=set_convergence_checks]{set_convergence_checks()}} function. See
\code{?set_convergence_checks} for options and default settings.}

\item{save}{whether all models posterior distributions should be kept
after obtaining a model-averaged result. Defaults to \code{"all"} which
does not remove anything. Set to \code{"min"} to significantly reduce
the size of final object, however, some model diagnostics and further
manipulation with the object will not be possible.}

\item{seed}{a seed to be set before model fitting, marginal likelihood
computation, and posterior mixing for reproducibility of results. Defaults
to \code{NULL} - no seed is set.}

\item{silent}{whether all print messages regarding the fitting process
should be suppressed. Defaults to \code{TRUE}. Note that \code{parallel = TRUE}
also suppresses all messages.}

\item{...}{additional arguments.}
}
\value{
\code{RoBTT} returns an object of class 'RoBTT'.
}
\description{
\code{update.RoBTT} can be used to
\enumerate{
\item{change the prior odds of fitted models by specifying a vector
\code{prior_weights} of the same length as the fitted models,}
\item{refitting models that failed to converge with updated settings
of control parameters,}
\item{or changing the convergence criteria and recalculating the ensemble
results by specifying new \code{control} argument and setting
\code{refit_failed == FALSE}.}
}
}
\details{
See \code{\link[=RoBTT]{RoBTT()}} for more details.
}
\seealso{
\code{\link[=RoBTT]{RoBTT()}}, \code{\link[=summary.RoBTT]{summary.RoBTT()}}, \code{\link[=prior]{prior()}}, \code{\link[=check_setup]{check_setup()}}
}
