% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RobPCA_SM.R
\name{pcaRobS}
\alias{pcaRobS}
\alias{SMPCA}
\title{Robust principal components}
\usage{
pcaRobS(X, ncomp, desprop = 0.9, deltasca = 0.5, maxit = 100)
}
\arguments{
\item{X}{a data matrix with observations in rows.}

\item{ncomp}{desired (maximum) number of components}

\item{desprop}{desired (minimum) proportion of explained variability (default = 0.9)}

\item{deltasca}{"delta" parameter of the scale M-estimator (default=0.5)}

\item{maxit}{maximum number of iterations (default= 100)}
}
\value{
A list with the following components:
\item{q}{The actual number of principal components}
\item{propex}{The actual proportion of unexplained variability}
\item{eigvec}{Eigenvectors, in a \code{p x q} matrix}
\item{fit}{an \code{n x p} matrix with the rank-q approximation to \code{X}}
\item{repre}{An \code{n x q} matrix with representation of data in R^q (scores)}
\item{propSPC}{A vector of length \code{p} with the cumulative explained variance from initial SPC}
}
\description{
This function computes robust principal components based on the minimization of
the "residual" M-scale.
}
\examples{
data(bus)
X0 <- as.matrix(bus)
X1 <- X0[,-9]
ss <- apply(X1, 2, mad)
mu <- apply(X1, 2, median)
X <- scale(X1, center=mu, scale=ss)
q <- 3  #compute three components
rr <- pcaRobS(X, q, 0.99)
round(rr$eigvec, 3)

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Ricardo Maronna, \email{rmaronna@retina.ar}, based on original code
by D. Pen~a and J. Prieto
}
