% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmrobdet.R
\name{lmrobdetMM}
\alias{lmrobdetMM}
\title{Robust Linear Regression Estimators}
\usage{
lmrobdetMM(
  formula,
  data,
  subset,
  weights,
  na.action,
  model = TRUE,
  x = !control$compute.rd,
  y = FALSE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset = NULL,
  control = lmrobdet.control()
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{data}{an optional data frame, list or environment containing
the variables in the model. If not found in \code{data}, model variables
are taken from \code{environment(formula)}, which usually is the
root environment of the current R session.}

\item{subset}{an optional vector specifying a subset of observations to be used.}

\item{weights}{an optional vector of weights to be used in the fitting process.}

\item{na.action}{a function to indicates what should happen when the data contain NAs.
The default is set by the \link{na.action} setting of \code{\link[base]{options}}, and is
\code{na.fail} if that is unset.}

\item{model}{logical value indicating whether to return the model frame}

\item{x}{logical value indicating whether to return the model matrix}

\item{y}{logical value indicating whether to return the vector of responses}

\item{singular.ok}{logical value. If \code{FALSE} a singular fit produces an error.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \link{model.matrix.default}.}

\item{offset}{this can be used to specify an a priori known component to be included
in the linear predictor during fitting. An offset term can be included in the formula
instead or as well, and if both are specified their sum is used.}

\item{control}{a list specifying control parameters as returned by the function
\link{lmrobdet.control}.}
}
\value{
A list with the following components:
\item{coefficients}{The estimated vector of regression coefficients}
\item{scale}{The robust residual M-scale estimate using the final residuals from the converged iterated weighted least square (IRWLS) algorithm final estimate}
\item{residuals}{The vector of residuals associated with the robust fit}
\item{loss}{Value of the objective function at the final MM-estimator}
\item{converged}{Logical value indicating whether IRWLS iterations for the MM-estimator have converged}
\item{iter}{Number of IRWLS iterations for the MM-estimator}
\item{rweights}{Robustness weights for the MM-estimator}
\item{fitted.values}{Fitted values associated with the robust fit}
\item{rank}{Numeric rank of the fitted linear model}
\item{cov}{The estimated covariance matrix of the regression estimates}
\item{df.residual}{The residual degrees of freedom}
\item{degree.freedom}{The residual degrees of freedom}
\item{scale.S}{Minimum robust scale associated with the preliminary highly robust but inefficient S-estimator.}
\item{r.squared}{The robust multiple correlation coefficient}
\item{adj.r.squared}{The adjusted robust multiple correlation coefficient taking into account the degrees of freedom of each term}
\item{contrasts}{(only where relevant) the contrasts used}
\item{xlevels}{(only where relevant) a record of the levels of the factors used in fitting}
\item{call}{the matched call}
\item{model}{if requested, the model frame used}
\item{x}{if requested, the model matrix used}
\item{y}{if requested, the response vector used}
\item{terms}{The \link{terms} object used.}
\item{iters.py}{The number of refinement iterations for each Pena-Yohai candidate for the S-estimator.}
\item{iters.const}{The number of refinement iterations used to compute the estimator without covariates (to calculate the robust R^2).}
\item{assign}{Used to separate continuous from categorical columns in the design matrix}
\item{na.action}{(where relevant) information returned by model.frame on the special handling of NAs}
}
\description{
This function computes an MM-regression estimators for linear models
using deterministic starting points.
}
\details{
This function computes MM-regression estimators
computed using Pen~a-Yohai candidates (instead of subsampling ones).
This function makes use of the functions \code{lmrob.fit},
\code{lmrob..M..fit}, \code{.vcov.avar1}, \code{lmrob.S} and
\code{lmrob.lar}, from robustbase,
along with utility functions used by these functions,
modified so as to include use of the analytic form of the
optimal psi and rho functions (for the optimal psi function , see
Section 5.8.1 of Maronna, Martin, Yohai and Salibian Barrera, 2019).
}
\section{Choice of Rho Loss Function}{


This is done by the user choice of family = "opt" or family = "mopt"
in the function lmrobdet.control. As of RobStatTM Versopm 1.0.7, the
opt and mopt rhos functions are calculated using polynomials, rather
than using the standard normal error function (erf) as in versions of
RobStatTM prior to 1.0.7. The numerical results one now gets with the
opt or mopt choices will differ by small amounts from those in earlier
RobStatTM versions. Users who wish to replicate results from releases
prior to 1.0.7 may do so using the family arguments family = "optV0" 
or family = "moptV0". Note that the derivative of the rho loss function,
known as the "psi" function, is not the derivative of the rho polynomial,
instead it is still the optimal psi function referred to above.
}

\section{Related Vignettes}{
 

For further details, see the Vignettes "Polynomial Opt and mOpt Rho Functions",
and "Optimal Bias Robust Regression Psi and Rho".
}

\examples{
data(coleman, package='robustbase')
m2 <- lmrobdetMM(Y ~ ., data=coleman)
m2
summary(m2)

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\link{DCML}, \link{MMPY}, \link{SMPY}
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, based on \code{lmrob} from package \code{robustbase}
}
