% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_orders.R
\name{api_orders}
\alias{api_orders}
\title{RobinHood API: Orders}
\usage{
api_orders(RH, action, order_url = NULL, instrument_id = NULL,
  symbol = NULL, type = NULL, time_in_force = NULL, trigger = NULL,
  price = NULL, stop_price = NULL, quantity = NULL, side = NULL)
}
\arguments{
\item{RH}{object of class RobinHood}

\item{action}{(string) one of "order", "status", "cancel", or "history"}

\item{order_url}{(string) action is "status" or "cancel", only order_url is required}

\item{instrument_id}{(string) URL of the instrument_id}

\item{symbol}{(string) Ticket symbol you are attempting to buy or sell}

\item{type}{(string) "market" or "limit"}

\item{time_in_force}{(string) Good For Day ("gfd"), Good Till Canceled ("gtc"), Immediate or Cancel ("ioc"), or Opening ("opg")}

\item{trigger}{(string) "immediate" or "stop"}

\item{price}{(number) the price you are willing to sell or buy at}

\item{stop_price}{(number) if trigger = stop, enter stop price, otherwise leave blank}

\item{quantity}{(int) number of shares you wish to transact}

\item{side}{(string) "buy" or "sell"}
}
\description{
Backend function called by place_order(), get_order_status(), cancel_order(). Issues a buy/sell order or
returns the status of an order. When issuing a buy order use the url column in the return data to check the
status or cancel the order.
}
