% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MissingValue.R
\name{MV.missingValueCompletion}
\alias{MV.missingValueCompletion}
\title{Wrapper function of missing value completion}
\usage{
MV.missingValueCompletion(decision.table, type.method = "deletionCases")
}
\arguments{
\item{decision.table}{a \code{"DecisionTable"} class representing a decision table. See \code{\link{SF.asDecisionTable}}.
Note: missing values are recognized as NA.}

\item{type.method}{one of the following methods:
\itemize{
\item \code{"deletionCases"}: See \code{\link{MV.deletionCases}}.
\item \code{"mostCommonValResConcept"}: See \code{\link{MV.mostCommonValResConcept}}.
\item \code{"mostCommonVal"}: See \code{\link{MV.mostCommonVal}}.
\item \code{"globalClosestFit"}: See \code{\link{MV.globalClosestFit}}.
\item \code{"conceptClosestFit"}: See \code{\link{MV.conceptClosestFit}}.
}}
}
\value{
A class \code{"MissingValue"} which contains
         \itemize{
         \item \code{val.NA}: a matrix containing indices of missing value (i.e., unknown values) positions and their values.
         \item \code{type.method}: a string showing the type of used method. In this case, it is \code{"deleteCases"}.
         }
}
\description{
It is a wrapper function for missing value completion.
}
\examples{
#############################################
## Example :
#############################################
dt.ex1 <- data.frame(
     c(100.2, 102.6, NA, 99.6, 99.8, 96.4, 96.6, NA),
     c(NA, "yes", "no", "yes", NA, "yes", "no", "yes"),
     c("no", "yes", "no", "yes", "yes", "no", "yes", NA),
     c("yes", "yes", "no", "yes", "no", "no", "no", "yes"))
colnames(dt.ex1) <- c("Temp", "Headache", "Nausea", "Flu")
decision.table <- SF.asDecisionTable(dataset = dt.ex1, decision.attr = 4,
                                    indx.nominal = c(2:4))
indx = MV.missingValueCompletion(decision.table, type.method = "deletionCases")

## generate new decision table
new.decTable <- SF.applyDecTable(decision.table, indx)
}
\author{
Lala Septem Riza
}
\references{
J. Grzymala-Busse and W. Grzymala-Busse, "Handling Missing Attribute Values," in Data Mining and Knowledge Discovery Handbook,
O. Maimon and L. Rokach, Eds. New York : Springer, 2010, pp. 33-51
}
\seealso{
\code{\link{MV.deletionCases}}, \code{\link{MV.mostCommonValResConcept}}, \code{\link{MV.mostCommonVal}},
      \code{\link{MV.globalClosestFit}}, and \code{\link{MV.conceptClosestFit}}.
}

