% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IOFunctions.R
\name{SF.asDecisionTable}
\alias{SF.asDecisionTable}
\title{Converting a data.frame into a \code{DecisionTable} object}
\usage{
SF.asDecisionTable(dataset, decision.attr = NULL, indx.nominal = NULL)
}
\arguments{
\item{dataset}{data.frame that contains objects/instances and attributes/features in its rows and columns, respectively.
See in Section \code{Details}.}

\item{decision.attr}{an integer value representing the index position of the decision attribute. If this parameter is ignored, then
the function will treat the data as an information system or newdata/test data. In other words,
it is necessary to define the index of the decision attribute in order to construct a decision table (e.g. a training data set).}

\item{indx.nominal}{a logical vector indicating nominal attributes in the data.
If this parameter is not given, then the function will use a heuristic to guess which of the attributes are nominal.
The following rules will be applied used:
    \itemize{
    \item an attribute contains character values or factors: it will be recognized as a nominal attribute.
    \item an attribute contains integer or numeric values: it will be recognized as a numeric attribute.
    \item indx.nominal: the indicated attributes will be considered as nominal.
    }}
}
\value{
An object of the \code{"DecisionTable"} class.
}
\description{
This function converts \code{data.frames} into \code{DecisionTable} objects. This is a standard data representation
in the \code{RoughSets} package.
}
\details{
An object of the \code{"DecisionTable"} class adds a few attributes to a standard data.frame:
\itemize{
  \item \code{desc.attrs}: a list containing the names of attributes and their range/possible symbolic values.
                           There are two kinds of representation in this parameters which depend on whether the attributes are
                           nominal or numeric, for example:
                           \itemize{
                             \item nominal attribute: \code{a = c(1,2,3)} means that the attribute \code{a} has values 1, 2, and 3.
                             \item numeric attribute: \code{a = c(10, 20)} means that the attribute \code{a} has values between 10 and 20.
                           }
  \item \code{nominal.attrs}: a logical vector whose length equals the number of columns in the data. In this vector \code{TRUE} values
                           indicate that the corresponding attribute is a nominal. For example:
                           \code{nominal.attrs = c(FALSE, TRUE, FALSE)} means that the first and third attributes
                           are numeric and the second one is nominal.
 \item \code{decision.attr}: a numeric value representing the index of the decision attribute. It is necessary to define
                           the index of the decision attribute in order to construct a proper decision system. If the value
                           of \code{decision.attr} is NULL, the constructed object will correspond to an information system.
                           It is strongly recommended to place the decision attribute as the last data column.
}
\code{"DecisionTable"} objects allow to use all methods of standard data.frame objects.
The function \code{\link{SF.read.DecisionTable}} can be used to import data from a file and then construct \code{DecisionTable} object.
}
\examples{
################################################################
## Example : converting from datasets in data.frame
##            into decision table
################################################################
## Let use iris which is available in R be dataset
decision.table <- SF.asDecisionTable(dataset = iris, decision.attr = 5,
                  indx.nominal = 5)
}
\seealso{
\code{\link{SF.read.DecisionTable}}, \code{\link{SF.applyDecTable}}.
}
\author{
Andrzej Janusz
}
