% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_proto.R
\name{pdb_make_proto_ipm}
\alias{pdb_make_proto_ipm}
\title{Generate proto_ipms from Padrino objects}
\usage{
pdb_make_proto_ipm(pdb, ipm_id = NULL, det_stoch = "det", kern_param = "kern")
}
\arguments{
\item{pdb}{A \code{pdb} object.}

\item{ipm_id}{Optionally, one or more \code{ipm_id}'s to build. If empty,
all models contained in the \code{pdb} object will be processed into
\code{proto_ipm}'s.}

\item{det_stoch}{A vector containing either \code{"det"} or \code{"stoch"}.
This determines whether we want to construct a deterministic or stochastic
model. Default is \code{"det"}. See details}

\item{kern_param}{If \code{det_stoch = "stoch"}, then whether or not to construct
a kernel resampled model, or a parameter resampled model. See details.}
}
\value{
A list containing one or more \code{proto_ipms}. Names of the list
will correspond to \code{ipm_id}s.
}
\description{
This function generates \code{proto_ipm} objects from
Padrino Database tables.
}
\details{
\code{proto_ipm} objects contain all of the information needed
to implement an IPM, but stop short of actually generating kernels. These
are intermediate building blocks that can be modified before creating a full
IPM so that things like perturbation analysis are a bit more straightforward.

When requesting many models, the \code{det_stoch} and \code{kern_param} parameters
can also be vectors. These are matched with \code{ipm_id} by position. If the
lengths of \code{det_stoch} and \code{kern_param} do not match the length
\code{ipm_id}, they will be recycled until they do.

For stochastic models, there is sometimes the option of building either a kernel-resampled
or a parameter resampled model. A kernel resampled model uses some point estimate
for time and/or space varying parameters to generate kernels for each year/site/grouping factor.
Parameter resampled models sample parameters from distributions. Padrino stores this
information for some models when it is available in the literature, and tries
to fail informatively when these distributions aren't available in the database.
}
\seealso{
For more info on \code{kern_param} definitions:

Metcalf \emph{et al.} (2015). Statistial modeling of annual variation
for inference on stochastic population dynamics using Integral Projection Models.
\emph{Methods in Ecology and Evolution}. DOI: 10.1111/2041-210X.12405
}
