% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.get.R
\name{pipelines.get}
\alias{pipelines.get}
\title{Get one pipeline}
\usage{
pipelines.get(id, totals_convert_currency = NULL, api_token = NULL,
  company_domain = "api")
}
\arguments{
\item{id}{ID of the pipeline to fetch.}

\item{totals_convert_currency}{3-letter currency code of any of the supported currencies. When supplied, per_stages_converted is returned in deals_summary which contains the currency-converted total amounts in the given currency per each stage. You may also set this parameter to 'default_currency' in which case users default currency is used.}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get one pipeline from pipedrive.
}
\examples{
\donttest{
pipelines.get(id='e.g.',api_token='token',company_domain='exp')
}
}
