% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recents.get.R
\name{recents.get}
\alias{recents.get}
\title{Get recents}
\usage{
recents.get(since_timestamp, items = NULL, start = NULL,
  limit = NULL, api_token = NULL, company_domain = "api")
}
\arguments{
\item{since_timestamp}{Timestamp in UTC. Format: YYYY-MM-DD HH:MM:SS}

\item{items}{Multiple selection of item types to include in query (optional) This field has the following domains: (activity; activityType; deal; delete_log; file; filter; note; person; organization; pipeline; product; stage; user)}

\item{start}{Pagination start}

\item{limit}{Items shown per page}

\item{api_token}{To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>}

\item{company_domain}{How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>}
}
\value{
return an object List()
}
\description{
Function to Get recents from pipedrive.
}
\examples{
\donttest{
recents.get(since_timestamp='e.g.',api_token='token',company_domain='exp')
}
}
