#' @title Add a new pipeline
#' @description Function to Add a new pipeline on pipedrive.
#' @param name Name of the pipeline
#' @param deal_probability Whether deal probability is disabled or enabled for this pipeline. This field has the following domains: (0; 1)
#' @param order_nr Defines pipelines order. First order(order_nr=0) is the default pipeline.
#' @param active Whether this pipeline will be made inactive (hidden) or active This field has the following domains: (0; 1)
#' @param api_token To validate your requests, you'll need your api_token - this means that our system will need to know who you are and be able to connect all actions you do with your chosen Pipedrive account. Have in mind that a user has a different api_token for each company. Please access the following link for more information: <https://pipedrive.readme.io/docs/how-to-find-the-api-token?utm_source=api_reference>
#' @param company_domain How to get the company domain: <https://pipedrive.readme.io/docs/how-to-get-the-company-domain>
#' @param return_type the default return is an object List with all informations of process, or you can set boolean (TRUE = success, FALSE = error)
#' @return customizable return, the default is an object List
#' @export
#' @examples \donttest{
#' pipelines.add(api_token='token',company_domain='exp')
#' }
pipelines.add <- function(name=NULL, deal_probability=NULL, order_nr=NULL, active=NULL, api_token=NULL, company_domain='api', return_type = c('complete','boolean')){
api_token <- check_api_token_(api_token)
url <- 'https://{company_domain}.pipedrive.com/v1/pipelines?'
bodyList <- list(name=name,deal_probability=deal_probability,order_nr=order_nr,active=active)
bodyList <- clear_list_(bodyList)
url <- sub('{company_domain}',company_domain, url, fixed = TRUE)
url <- paste0(url, 'api_token={api_token}')
url <- sub('{api_token}',api_token, url, fixed = TRUE)
r <- httr::POST(url,  body = bodyList, encode = 'json')
if(return_type[1] == 'boolean'){
if(r$status_code %in% c(200,201)){return(TRUE)}else{return(FALSE)}
}else{return(r)}
}
