% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{undiff_Sigma}
\alias{undiff_Sigma}
\title{Transform differenced to non-differenced error term covariance matrix}
\usage{
undiff_Sigma(Sigma, i, checks = TRUE, pos = TRUE, labels = TRUE)
}
\arguments{
\item{Sigma}{An error term covariance matrix of dimension \code{J-1} x \code{J-1} which
was differenced with respect to alternative \code{i}.}

\item{i}{An integer, the alternative number with respect to which \code{Sigma}
was differenced.}

\item{checks}{If \code{TRUE} the function runs additional input and transformation checks.}

\item{pos}{If \code{TRUE} the function returns a positive matrix.}

\item{labels}{If \code{TRUE} the function adds labels to the output matrix.}
}
\value{
A covariance matrix of dimension \code{J} x \code{J}. If this covariance
matrix gets differenced with respect to alternative \code{i}, the results is
again \code{Sigma}.
}
\description{
This function transforms the differenced error term covariance matrix
\code{Sigma} back to a non-differenced error term covariance matrix.
}
\examples{
J <- 3
i <- 2
Sigma_full <- rwishart(3, diag(3))$W
Sigma <- delta(J, 2) \%*\% Sigma_full \%*\% t(delta(J, 2))
Sigma_back <- RprobitB:::undiff_Sigma(Sigma = Sigma, i = 2)
}
\keyword{internal}
