% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saga.R
\name{saga_env}
\alias{saga_env}
\title{Parses valid SAGA-GIS libraries and tools into a nested list of functions}
\usage{
saga_env(saga_bin = NULL, opt_lib = NULL, backend = "raster")
}
\arguments{
\item{saga_bin}{An optional character vector to specify the path to the
saga_cmd executable. Otherwise the function will perform a search for
saga_cmd.}

\item{opt_lib}{A character vector of a subset of SAGA-GIS tool libraries to
generate dynamic functions that map to each tool. Used to save time if you
only want to import a single library.}

\item{backend}{A character vector to specify the library to use for handling
raster data. Currently, either "raster", "terra" or "stars" is supported.
The default is "raster".}
}
\value{
A saga environment S3 object containing paths, settings and a nested
  list of libraries tools and options.
}
\description{
Establishes the link to SAGA GIS by generating a SAGA help file and parsing
all libraries, tools and options from the help files into a nested list of
library, module and options, that are contained within an saga environment
object object. Intended to be used internally by \code{\link{saga_gis}}
}
