% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_data.R
\name{export_data}
\alias{export_data}
\title{Export experiment data to a trackxf file.}
\usage{
export_data(experiment, file, tracks = "all")
}
\arguments{
\item{experiment}{An \code{rtrack_experiment} object from
\code{\link{read_experiment}}.}

\item{file}{The file to which the archive will be written. This should
ideally use the file extension \code{.trackxf} although other extensions
are also possible. If the filename is given without any extension
(recommended), then the \code{.trackxf} extension will be added
automatically.}

\item{tracks}{Which tracks should be exported. Default, "all" exports the
entire experiment object. A subset of tracks can be specified using either
numeric indices or a vector of track IDs following usual R standards.}
}
\description{
Creates a representation of the experiment data in the trackxf format and
writes this to file.
}
\details{
The exported trackxf file contains all the raw data and experiment metadata.
The trackxf archive contains exactly the same information as if reading from
raw data. Calculated metrics are not exported, but can be recreated exactly.

A formal description of the trackxf JSON format can be found in the schema
file at \url{https://rupertoverall.net/trackxf/trackxf_schema_v0.json}.
}
\examples{
require(Rtrack)
experiment.description <- system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
experiment <- read_experiment(experiment.description, format = "excel",
  project.dir = system.file("extdata", "", package = "Rtrack"))
tempfile <- file.path(tempdir(), "Minimal_experiment.trackxf") # Temporary file
export_data(experiment, file = tempfile)
imported.experiment <- read_experiment(tempfile, format = "trackxf")
# Experiments are identical except for export timestamp/notes
all.equal(experiment, imported.experiment)
identical(experiment$metrics, imported.experiment$metrics)

}
\seealso{
\code{\link{read_experiment}} to import the archive back into an
  \code{rtrack_experiment} object.
}
