% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgClean.r
\name{vcgClean}
\alias{vcgClean}
\title{Clean triangular surface meshes}
\usage{
vcgClean(mesh, sel = 0, tol = 0, silent = FALSE, iterate = FALSE)
}
\arguments{
\item{mesh}{triangular mesh of class 'mesh3d'}

\item{sel}{integer vector selecting cleaning type (see "details"),}

\item{tol}{numeric value determining Vertex Displacement Ratio used for splitting non-manifold vertices.}

\item{silent}{logical, if TRUE no console output is issued.}

\item{iterate}{logical: if TRUE, vcgClean is repeatedly run until nothing more is to be cleaned (see details).}
}
\value{
cleaned mesh with an additional entry
\item{remvert}{vector of length = number of vertices before cleaning. Entries = 1 indicate that this vertex was removed; 0 otherwise.}
}
\description{
Apply several cleaning algorithms to surface meshes
}
\details{
the vector sel determines which operations are performed in which order. E.g. removing degenerate faces may generate unreferenced vertices, thus the ordering of cleaning operations is important, multiple calls are possible (sel=c(1,3,1) will remove unreferenced vertices twice).
available options are:

\itemize{
\item{0 = only duplicated vertices and faces are removed}
\item{1 = remove unreferenced vertices}
\item{2 = Remove non-manifold Faces}
\item{3 = Remove degenerate faces}
\item{4 = Remove non-manifold vertices}
\item{5 = Split non-manifold vertices by threshold}
\item{6 = merge close vertices (radius=\code{tol})}
\item{7 = coherently orient faces}
}
}
\examples{
data(humface)
cleanface <- humface
##add duplicated faces
cleanface$it <- cbind(cleanface$it, cleanface$it[,1:100])
## add duplicated vertices
cleanface$vb <- cbind(cleanface$vb,cleanface$vb[,1:100])
## ad unreferenced vertices
cleanface$vb <- cbind(cleanface$vb,rbind(matrix(rnorm(18),3,6),1))
cleanface <- vcgClean(cleanface, sel=1)
}

