% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgIsosurface.r
\name{vcgIsosurface}
\alias{vcgIsosurface}
\title{Create Isosurface from 3D-array}
\usage{
vcgIsosurface(
  vol,
  threshold,
  from = NULL,
  to = NULL,
  spacing = NULL,
  origin = NULL,
  direction = NULL,
  IJK2RAS = diag(c(-1, -1, 1, 1)),
  as.int = FALSE
)
}
\arguments{
\item{vol}{an integer valued 3D-array}

\item{threshold}{threshold for creating the surface}

\item{from}{numeric: the lower threshold of a range (overrides \code{threshold})}

\item{to}{numeric: the upper threshold of a range (overrides \code{threshold})}

\item{spacing}{numeric 3D-vector: specifies the voxel dimensons in x,y,z direction.}

\item{origin}{numeric 3D-vector: origin of the original data set, will transpose the mesh onto that origin.}

\item{direction}{a 3x3 direction matrix}

\item{IJK2RAS}{4x4 IJK2RAS transformation matrix}

\item{as.int}{logical: if TRUE, the array will be stored as integer (might decrease RAM usage)}
}
\value{
returns a triangular mesh of class "mesh3d"
}
\description{
Create Isosurface from 3D-array using Marching Cubes algorithm
}
\examples{
#this is the example from the package "misc3d"
x <- seq(-2,2,len=50)
g <- expand.grid(x = x, y = x, z = x)
v <- array(g$x^4 + g$y^4 + g$z^4, rep(length(x),3))
storage.mode(v) <- "integer"
\dontrun{
mesh <- vcgIsosurface(v,threshold=10)
require(rgl)
wire3d(mesh)
##now smooth it a little bit
wire3d(vcgSmooth(mesh,"HC",iteration=3),col=3)
}
}
