% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RxODE.R
\name{rxModelVars}
\alias{rxModelVars}
\title{All model variables for a RxODE object}
\usage{
rxModelVars(obj)
}
\arguments{
\item{obj}{RxODE family of objects}
}
\value{
A list of RxODE model properties including:

\item{params}{ a character vector of names of the model parameters}
\item{lhs}{ a character vector of the names of the model calculated parameters}
\item{state}{ a character vector of the compartments in RxODE object}
\item{trans}{ a named vector of translated model properties
      including what type of jacobian is specified, the \code{C} function prefixes,
      as well as the \code{C} functions names to be called through the compiled model.}
\item{md5}{a named vector that gives the digest of the model (\code{file_md5}) and the parsed model
     (\code{parsed_md5})}
\item{model}{ a named vector giving the input model (\code{model}),
   normalized model (no comments and standard syntax for parsing, \code{normModel}),
   and interim code that is used to generate the final C file \code{parseModel}}
}
\description{
Return all the known model variables for a specified RxODE object
}
\details{
These items are only calculated after compilation; they are
built-into the RxODE compiled DLL.
}
\author{
Matthew L. Fidler
}
\keyword{internal}
