% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxode-options.R
\name{rxOptions}
\alias{rxOptions}
\title{Options for RxODE}
\usage{
rxOptions(
  expr,
  op.rx = NULL,
  silent = .isTestthat(),
  respect = FALSE,
  cran = FALSE,
  on.validate = FALSE
)
}
\arguments{
\item{expr}{Expression to evaluate in the permissive/strict
environment.  If unspecified, set the options for the current
environment.}

\item{op.rx}{A numeric for strict (1) or permissive (2) syntax.}

\item{silent}{when true, also silence the syntax errors and
interactive output (useful in testing).}

\item{respect}{when TRUE, respect any options that are specified.
This is called at startup, but really should not be called
elsewhere, otherwise the options are not changed.}

\item{cran}{When specified and true, run on CRAN. Otherwise it is skipped on CRAN.}

\item{on.validate}{When TRUE run only when validating.}
}
\description{
This is a backend for \code{rxPermissive} (with
\code{op.rx} = \code{2}) and \code{rxStrict} (with
\code{op.rx} =\code{1})
}
\details{
When \code{expr} is missing and \code{op.rx} is NULL, this
displays the current RxODE options.
}
\author{
Matthew L. Fidler
}
