rxodeTest(
  {
    context("Test Issue #8")
    test_that("Assign statement", {
      .rxWithOptions(list(RxODE.syntax.assign.state = TRUE), {
        theta <- c(a = 2, b = 3)
        ode <- RxODE({
          x <- max(x, 0)
          d / dt(x) <- x - a * y
          d / dt(y) <- b * x - 2 * y
        })

        inits <- c(x = 5, y = 2)

        ev <- eventTable()
        ev$add.sampling(0:20)

        x <- ode$run(theta, ev, inits = inits)

        expect_equal(x, structure(c(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 5, -0.0604266558587329, -2.72108276236761, -3.08116324259206, -3.12989471157, -3.13648978595066, -3.13738232926326, -3.13750312069768, -3.13751946984015, -3.13752168078141, -3.13752198015709, -3.13752202141731, -3.13752202664631, -3.13752202761832, -3.1375220277208, -3.13752202764479, -3.13752202758326, -3.13752202756275, -3.13752202755591, -3.13752202755363, -3.13752202755287, 2, 3.07709537169376, 0.416439265184878, 0.0563587849604279, 0.00762731598249176, 0.00103224160182767, 0.000139698289233015, 1.8906854807943e-05, 2.55771233904766e-06, 3.46771082386135e-07, 4.73954038696054e-08, 6.13518015444644e-09, 9.06184775398744e-10, -6.58336360348526e-11, -1.68313360002738e-10, -9.23043903380268e-11, -3.07681303993046e-11, -1.02560433921789e-11, -3.41868110597432e-12, -1.13956036040745e-12, -3.79853450718928e-13), .Dim = c(21L, 3L), .Dimnames = list(NULL, c("time", "x", "y"))))

        ode2 <- RxODE({
          d / dt(x) <- max(x, 0) - a * y
          d / dt(y) <- b * max(x, 0) - 2 * y
        })

        y <- ode2$run(theta, ev, inits = inits)

        expect_equal(x, y)

      })

      .rxWithOptions(list(RxODE.syntax.assign.state = FALSE), {
        expect_error(capture.output(RxODE({
          x <- max(x, 0)
          d / dt(x) <- x - a * y
          d / dt(y) <- b * x - 2 * y
        })))
      })
    })
  },
  test = "lvl2"
)
