% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnat_api.R
\name{xnat_connection}
\alias{xnat_connection}
\alias{xnat_connect}
\title{Make a connection to an XNAT server}
\usage{
xnat_connect(base_url, username = NULL, password = NULL,
  xnat_name = NULL)
}
\arguments{
\item{base_url}{the URL for the XNAT server}

\item{username}{user name to use for connection. If \code{NULL} this
can be provided through the \code{xxx_WEB_USER} system variable where
xxx is provided by the \code{xnat_name} parameter}

\item{password}{user name to use for connection. If \code{NULL} this
can be provided through the \code{xxx_WEB_PASS} system variable where
xxx is provided by the \code{xnat_name} parameter}

\item{xnat_name}{prefix to use for retrieving the proper username/pass
system variables for a specific XNAT server}
}
\value{
\code{projects}
}
\description{
Make the XNAT connection and provides
functions to retrieve the list of projects, experiments
and subjects.
}
\examples{
## Connect to the NITRC.ORG database
\dontrun{xnat_connect('https://nitrc.org/ir', xnat_name='NITRC')}

## Connect to the XNAT.CENTRAL database
\dontrun{xnat_connect('https://central.xnat.org', xnat_name="CENTRAL")}

}
