% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/y-fn.R
\name{y_eval}
\alias{y_eval}
\title{Evaluate a yacas expression}
\usage{
y_eval(expr, ..., as.r = FALSE)
}
\arguments{
\item{expr}{a valid yacas expression}

\item{...}{a list of assignements (see example)}

\item{as.r}{if TRUE, then the expression is evaluated as R (if any variable
to be substituted in the expression is a vector, then a vector is returned).
If it is FALSE (default), a yacc expression is returned, replacing scalar variables.}
}
\description{
Evaluate a yacas expression by replacing variables with values as for the
given list.
}
\examples{
# Evaluate as yacas object
eq <- ysym("2*y+x^2+2*x-3")
y_eval(eq, x=3, y=2)

# Evaluate as R expression:
y_eval(eq, x=3, y=2, as.r=TRUE)
# This allows to use vectors:
y_eval(eq, x=1:10, y=2, as.r=TRUE)
# and to plot functions:
curve(y_eval(eq, x=x, y=2, as.r=TRUE), xlim=c(0,10))
}
\concept{helper}
