% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special.R
\docType{data}
\name{class_missing}
\alias{class_missing}
\alias{class_any}
\title{Special dispatch types}
\format{
An object of class \code{S7_missing} of length 0.

An object of class \code{S7_any} of length 0.
}
\usage{
class_missing

class_any
}
\value{
Sentinel objects used for special types of dispatch.
}
\description{
\itemize{
\item Use \code{class_missing} when the user has not supplied an argument
\item Use \code{class_any} for a default method that is called only if no other
methods are matched
}
}
\examples{
foo <- new_generic("foo", "x")
method(foo, class_integer) <- function(x) "integer"
method(foo, class_missing) <- function(x) "missing"
method(foo, class_any) <- function(x) "fallback"

foo(1)
foo()
foo("x")
}
\keyword{datasets}
