% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRunPlot.R
\name{multiRunPlot}
\alias{multiRunPlot}
\title{Plot the results from multipe COBRA runs.}
\usage{
multiRunPlot(dfAll, optim = NULL, fName = "multiRun", main = "",
  xlim = NULL, ylim = c(1e-05, 10000), ylog = TRUE, xlog = FALSE,
  target = 0.05, plotPDF = FALSE, subPDF = NULL,
  legendWhere = "topright", absErr = FALSE)
}
\arguments{
\item{dfAll}{the data frame of all runs, obtained with \code{\link{multiCOBRA}} or loaded 
from .Rdata file}

\item{optim}{[NULL] the true optimum (or best known value) of the problem (only for diagnostics).
If \code{optim==NULL}, we plot instead of errors the ever-best feasible values.}

\item{fName}{["multiRun"] the name of the .Rdata file, printed as subtitle}

\item{main}{[""] the name of the problem (e.g. "G01 problem"), printed as title}

\item{xlim}{the x limits}

\item{ylim}{the y limits}

\item{ylog}{[TRUE]  logarithmic y-axis}

\item{xlog}{[FALSE] logarithmic x-axis}

\item{target}{[0.05] a single run meets the target, if the final error is smaller than \code{target}}

\item{plotPDF}{[FALSE] if TRUE, plot to 'fName'.pdf}

\item{subPDF}{[NULL] optional subdirectory where .pdf should go}

\item{legendWhere}{["topright"]}

\item{absErr}{[FALSE] if TRUE, plot abs(error) instead of error.}
}
\value{
\code{z3}, a vector containing for each run the ever-best feasible objective value
}
\description{
Plot for each run one black curve 'error vs. iterations' and aggregate the mean curve (red) and 
the median curve (green) of all runs. 'error' is the distance between the ever-best feasible 
value and \code{optim}.
}
\details{
Print some diagnostic information: final median & mean error, percentage of runs which meet the
target (only if \code{optim} is available)). \cr
}
\seealso{
\code{\link{multiRunPlot_2}}, \code{\link{multiCOBRA}}, \code{\link{cobraPhaseII}}
}
\author{
Wolfgang Konen, Samineh Bagheri, Cologne University of Applied Sciences
}
