% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RbfInter.R
\name{trainGaussRBF}
\alias{trainGaussRBF}
\title{Fit Gaussian RBF model to training data for d>1.}
\usage{
trainGaussRBF(xp, U, ptail = TRUE, squares = FALSE, width, RULE = "One",
  widthFactor = 1, rho = 0, DEBUG2 = F)
}
\arguments{
\item{xp}{n points \eqn{x_i} of dimension d are arranged in (n x d) matrix \code{xp}}

\item{U}{vector of length n, containing samples \eqn{u(x_i)} of 
the scalar function \eqn{u} to be fitted \cr
- or - \cr
(n x m) matrix, where each column 1,...,m contains one vector of samples
\eqn{u_j(x_i)} for the m'th model, j=1,...,m}

\item{ptail}{[TRUE] flag, see description}

\item{squares}{[FALSE] flag, see 'Description'}

\item{width}{[-1] either a positive real value which is the constant width \eqn{\sigma} for all 
Gaussians in all iterations, or -1. If -1, the appropriate width \eqn{\sigma} is 
calculated anew in each iteration with one of the rules \code{RULE},
based on the distribution of data points \code{xp}.}

\item{RULE}{["One"] one out of ["One" | "Two" | "Three"], different rules for automatic 
estimation of width \eqn{\sigma}. Only relevant if \code{width = -1},}

\item{widthFactor}{[1.0] additional constant factor applied to each width \eqn{\sigma}}

\item{rho}{[0.0] experimental: 0.0: interpolating, >0.0, approximating (spline-like) 
Gaussian RBFs}

\item{DEBUG2}{[FALSE] if TRUE, save \code{M} and \code{rhs} on return value}
}
\value{
\code{rbf.model},  an object of class \code{RBFinter}, which is basically a list 
     with elements:
     \item{coef}{  (n+d+1 x m) matrix holding in column m the coefficients for the m'th 
                   model:      \eqn{\lambda_1, ..., \lambda_n, c_0, c_1, ..., c_d}.  
                   In case \code{squares==TRUE} it is an (n+2d+1 x m) matrix holding  
                   additionally the coefficients \eqn{c_{d+1}, ..., c_{d+d}}.}
     \item{xp}{ matrix xp   }
     \item{d}{ size of the polynomial tail. If \code{length(d)==0} it means no polynomial tail will be used for the model. In case of ptail==T && squares==F d will be dimension+1 and in case of ptail==T && squares==T d will be 2*dimension+1 }
     \item{npts}{  number n of points \eqn{x_i} }
     \item{ptail}{TRUE or FALSE (see description)}
     \item{squares}{  TRUE or FALSE (see description)}
     \item{width}{ the calculated width \eqn{\sigma} }
     \item{type}{  "GAUSS"}
}
\description{
The model for a point \eqn{z=(z_1,...,z_d)} is fitted using n sample points \eqn{x_1, ..., x_n} 
\cr
   \deqn{ s(z) = \lambda_1*\Phi(||z-x_1||)+... +\lambda_n*\Phi(||z-x_n||)
                 + c_0 + c_1*z_1 + ... + c_d*z_d  }
\cr    
where \eqn{\Phi(r)=\exp(-r^2/(2*\sigma^2))} denotes the Gaussian radial basis function with width
\eqn{\sigma}. The coefficients \eqn{\lambda_1, ..., \lambda_n, c_0, c_1, ..., c_d} are determined 
by this training procedure.\cr
This is for the default case \code{squares==FALSE}. In case \code{squares==TRUE} 
there are d additional pure square terms and the model is
\cr
   \deqn{ s_{sq}(z) = s(z) + c_{d+1}*z_1^2 + ... + c_{d+d}*z_d^2 } 
In case \code{ptail==FALSE} the polynomial tail (all coefficients \eqn{c_i}) is omitted completely.
 
The linear equation system is solved via SVD inversion. Near-zero elements 
in the diagonal matrix \eqn{D} are set to zero in \eqn{D^{-1}}. This makes  
rank-deficient systems numerically stable.
}
\seealso{
\code{\link{trainCubicRBF}}, \code{\link{predict.RBFinter}}, \code{\link{interpRBF}}
}
\author{
Wolfgang Konen, Samineh Bagheri
}
