% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_assess_RCMdata.R
\docType{class}
\name{Assessment-class}
\alias{Assessment-class}
\alias{Assessment}
\title{Class-\code{Assessment}}
\description{
An S4 class that contains assessment output. Created from a function of class \code{Assess}.
}
\section{Slots}{

\describe{
\item{\code{Model}}{Name of the assessment model.}

\item{\code{Name}}{Name of Data object.}

\item{\code{conv}}{Logical. Whether the assessment model converged (defined by whether TMB returned a
positive-definite covariance matrix for the model).}

\item{\code{UMSY}}{Estimate of exploitation at maximum sustainable yield.}

\item{\code{FMSY}}{Estimate of instantaneous fishing mortality rate at maximum sustainable yield.}

\item{\code{MSY}}{Estimate of maximum sustainable yield.}

\item{\code{BMSY}}{Biomass at maximum sustainable yield.}

\item{\code{SSBMSY}}{Spawning stock biomass at maximum sustainable yield.}

\item{\code{VBMSY}}{Vulnerable biomass at maximum sustainable yield.}

\item{\code{B0}}{Biomass at unfished equilibrium.}

\item{\code{R0}}{Recruitment at unfished equilibrium.}

\item{\code{N0}}{Abundance at unfished equilibrium.}

\item{\code{SSB0}}{Spawning stock biomass at unfished equilibrium.}

\item{\code{VB0}}{Vulnerable biomass at unfished equilibrium.}

\item{\code{h}}{Steepness.}

\item{\code{U}}{Time series of exploitation.}

\item{\code{U_UMSY}}{Time series of relative exploitation.}

\item{\code{FMort}}{Time series of instantaneous fishing mortality.}

\item{\code{F_FMSY}}{Time series of fishing mortality relative to MSY.}

\item{\code{B}}{Time series of biomass.}

\item{\code{B_BMSY}}{Time series of biomass relative to MSY.}

\item{\code{B_B0}}{Time series of depletion.}

\item{\code{SSB}}{Time series of spawning stock biomass.}

\item{\code{SSB_SSBMSY}}{Time series of spawning stock biomass relative to MSY.}

\item{\code{SSB_SSB0}}{Time series of spawning stock depletion.}

\item{\code{VB}}{Time series of vulnerable biomass.}

\item{\code{VB_VBMSY}}{Time series of vulnerable biomass relative to MSY.}

\item{\code{VB_VB0}}{Time series of vulnerable biomass depletion.}

\item{\code{R}}{Time series of recruitment.}

\item{\code{N}}{Time series of population abundance.}

\item{\code{N_at_age}}{Time series of numbers-at-age matrix.}

\item{\code{Selectivity}}{Selectivity-at-age matrix.}

\item{\code{Obs_Catch}}{Observed catch.}

\item{\code{Obs_Index}}{Observed index.}

\item{\code{Obs_C_at_age}}{Observed catch-at-age matrix.}

\item{\code{Catch}}{Predicted catch.}

\item{\code{Index}}{Predicted index.}

\item{\code{C_at_age}}{Predicted catch-at-age matrix.}

\item{\code{Dev}}{A vector of estimated deviation parameters.}

\item{\code{Dev_type}}{A description of the deviation parameters, e.g. "log recruitment deviations".}

\item{\code{NLL}}{Negative log-likelihood. A vector for the total likelihood, integrated across random effects if applicable, components,
and penalty term (applied when \code{U > 0.975} in any year).}

\item{\code{SE_UMSY}}{Standard error of UMSY estimate.}

\item{\code{SE_FMSY}}{Standard error of FMSY estimate.}

\item{\code{SE_MSY}}{Standard error of MSY estimate.}

\item{\code{SE_U_UMSY}}{Standard error of U/UMSY.}

\item{\code{SE_F_FMSY}}{Standard error of F/FMSY.}

\item{\code{SE_B_BMSY}}{Standard error of B/BMSY.}

\item{\code{SE_B_B0}}{Standard error of B/B0.}

\item{\code{SE_SSB_SSBMSY}}{Standard error of SSB/SSBMSY.}

\item{\code{SE_SSB_SSB0}}{Standard error of SSB/SSB0.}

\item{\code{SE_VB_VBMSY}}{Standard error of VB/VBMSY.}

\item{\code{SE_VB_VB0}}{Standard error of VB/VB0.}

\item{\code{SE_Dev}}{A vector of standard errors of the deviation parameters.}

\item{\code{info}}{A list containing the data and starting values of estimated parameters
for the assessment.}

\item{\code{forecast}}{A list containing components for forecasting:
\itemize{
\item \code{per_recruit} A data frame of SPR (spawning potential ratio) and YPR (yield-per-recruit), calculated for
a range of exploitation rate of 0 - 0.99 or instantaneous F from 0 - 2.5 FMSY. 
\item \code{catch_eq} A function that calculates the catch for the next year (after the model terminal year) when an
apical F is provided. 
}}

\item{\code{obj}}{A list with components returned from \code{\link[TMB]{MakeADFun}}.}

\item{\code{opt}}{A list with components from calling \code{\link[stats]{nlminb}} to \code{obj}.}

\item{\code{SD}}{A list (class sdreport) with parameter estimates and their standard errors, obtained from
\code{\link[TMB]{sdreport}}.}

\item{\code{TMB_report}}{A list of model output reported from the TMB executable, i.e. \code{obj$report()}, and derived quantities (e.g. MSY).}

\item{\code{dependencies}}{A character string of data types required for the assessment.}
}}

\examples{
\donttest{
output <- DD_TMB(Data = MSEtool::SimulatedData)
class(output)
}
}
\seealso{
\link{plot.Assessment} \link{summary.Assessment} \link{retrospective} \link{profile} \link{make_MP}
}
\author{
Q. Huynh
}
