% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traceplot.R
\name{traceplot}
\alias{traceplot}
\title{Traceplot: plot MCMC chains}
\usage{
traceplot(object, params, 
          show_density = TRUE, 
          show_burnin = TRUE, 
          length_burnin = NULL, 
          show_convergence = TRUE, 
          trunc_plot = 10)
}
\arguments{
\item{object}{object of class \code{SANmcmc} (the result of a call to \code{\link{sample_fiSAN}}, 
\code{\link{sample_fiSAN_sparsemix}}, \code{\link{sample_fSAN}}, \code{\link{sample_fSAN_sparsemix}}, or \code{\link{sample_CAM}}).}

\item{params}{vector of strings with the names of the parameters to check.}

\item{show_density}{logical (default \code{TRUE}). Whether a kernel estimate of the density should be plotted. The burn-in is always discarded.}

\item{show_burnin}{logical (default \code{TRUE}). Whether the first part of the chains should be plotted in the traceplots.}

\item{length_burnin}{if \code{show_burnin = FALSE}, the length of the burn-in to be discarded.}

\item{show_convergence}{logical (default \code{TRUE}). Whether a superimposed red line of the cumulative mean should be plotted.}

\item{trunc_plot}{integer (default = 10). For multidimensional parameters, the maximum number of components to be plotted.}
}
\value{
The function displays the traceplots of the MCMC algorithm.
}
\description{
Check the convergence of the MCMC through visual inspection of the chains.
}
\note{
The function is not available for the observational weights \eqn{\omega}.
}
\examples{
set.seed(123)
y <- c(rnorm(40,0,0.3), rnorm(20,5,0.3))
g <- c(rep(1,30), rep(2, 30))
out <- sample_fiSAN(nrep = 500, y = y, group = g, 
                    nclus_start = 2,
                    maxK = 20, maxL = 20,
                    beta = 1)
traceplot(out, params = c("mu", "sigma2"), trunc_plot = 2)


}
