% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_BarPlot.R
\name{do_BarPlot}
\alias{do_BarPlot}
\title{Create Bar Plots.}
\usage{
do_BarPlot(
  sample,
  group.by,
  order = TRUE,
  split.by = NULL,
  position = "stack",
  font.size = 14,
  font.type = "sans",
  legend.position = "bottom",
  rotate_x_axis_labels = 45,
  legend.title = NULL,
  xlab = NULL,
  ylab = NULL,
  colors.use = NULL,
  flip = FALSE,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata column to compute the counts of. Has to be either a character or factor column.}

\item{order}{\strong{\code{\link[base]{logical}}} | Whether to order the results in descending order of counts.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Metadata column to split the values of group.by by. If not used, defaults to the active idents.}

\item{position}{\strong{\code{\link[base]{character}}} | Position function from \pkg{ggplot2}. One of:
\itemize{
\item \emph{\code{stack}}: Set the bars side by side, displaying the total number of counts. Uses \link[ggplot2]{position_stack}.
\item \emph{\code{fill}}: Set the bars on top of each other, displaying the proportion of counts from the total that each group represents. Uses \link[ggplot2]{position_fill}.
}}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{rotate_x_axis_labels}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the panels.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}
}
\value{
A ggplot2 object containing a Bar plot.
}
\description{
Create Bar Plots.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_BarPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic bar plot, horizontal.
    p1 <- SCpubr::do_BarPlot(sample = sample,
                             group.by = "seurat_clusters",
                             legend.position = "none",
                             plot.title = "Number of cells per cluster")

    # Split by a second variable.
    sample$modified_orig.ident <- sample(x = c("Sample_A", "Sample_B", "Sample_C"),
                                         size = ncol(sample),
                                         replace = TRUE,
                                         prob = c(0.2, 0.7, 0.1))

    p <- SCpubr::do_BarPlot(sample,
                            group.by = "seurat_clusters",
                            split.by = "modified_orig.ident",
                            plot.title = "Number of cells per cluster in each sample",
                            position = "stack")


  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
