% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_NebulosaPlot.R
\name{do_NebulosaPlot}
\alias{do_NebulosaPlot}
\title{Wrapper for Nebulosa::plot_density in Seurat.}
\usage{
do_NebulosaPlot(
  sample,
  features,
  slot = NULL,
  dims = c(1, 2),
  pt.size = 1,
  reduction = NULL,
  combine = TRUE,
  method = c("ks", "wkde"),
  joint = FALSE,
  return_only_joint = FALSE,
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  legend.type = "colorbar",
  legend.framewidth = 0.5,
  legend.tickwidth = 0.5,
  legend.length = 20,
  legend.width = 1,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  font.size = 14,
  font.type = "sans",
  legend.position = "bottom",
  plot_cell_borders = TRUE,
  border.size = 2,
  border.color = "black",
  viridis_color_map = "G",
  viridis_direction = 1,
  verbose = TRUE,
  na.value = "grey75",
  plot.axes = FALSE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{features}{\strong{\code{\link[base]{character}}} | Features to represent.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{dims}{\strong{\code{\link[base]{numeric}}} | Vector of 2 numerics indicating the dimensions to plot out of the selected reduction. Defaults to c(1, 2) if not specified.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{reduction}{\strong{\code{\link[base]{character}}} | Reduction to use. Can be the canonical ones such as "umap", "pca", or any custom ones, such as "diffusion". If you are unsure about which reductions you have, use \code{Seurat::Reductions(sample)}. Defaults to "umap" if present or to the last computed reduction if the argument is not provided.}

\item{combine}{\strong{\code{\link[base]{logical}}} | Whether to create a single plot out of multiple features.}

\item{method}{Kernel density estimation method:
\itemize{
\item \code{ks}: Computes density using the \code{kde} function from the
 \code{ks} package.
\item \code{wkde}: Computes density using a modified version of the
\code{kde2d} function from the \code{MASS}
package to allow weights. Bandwidth selection from the \code{ks} package
 is used instead.
}}

\item{joint}{\strong{\code{\link[base]{logical}}} | Whether to plot different features as joint density.}

\item{return_only_joint}{\strong{\code{\link[base]{logical}}} | Whether to only return the joint density panel.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
\item \emph{\code{colorsteps}}: Redefined legend with colors going by range, in steps, using \link[ggplot2]{guide_colorsteps}.
}}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{plot_cell_borders}{\strong{\code{\link[base]{logical}}} | Whether to plot border around cells.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color to use for the border of the cells.}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{verbose}{\strong{\code{\link[base]{logical}}} | Whether to show extra comments, warnings,etc.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{plot.axes}{\strong{\code{\link[base]{logical}}} | Whether to plot axes or not.}
}
\value{
A ggplot2 object containing a Nebulosa plot.
}
\description{
Wrapper for Nebulosa::plot_density in Seurat.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_NebulosaPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic Nebulosa plot.
    p <- SCpubr::do_NebulosaPlot(sample = sample,
                                 features = "EPC1")

    # Compute joint density.
    p <- SCpubr::do_NebulosaPlot(sample = sample,
                                 features = c("EPC1", "TOX2"),
                                 joint = TRUE)

  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
