% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_AzimuthAnalysisPlot.R
\name{do_AzimuthAnalysisPlot}
\alias{do_AzimuthAnalysisPlot}
\title{Generate a report from a Seurat object that has been mapped to a reference using Azimuth.}
\usage{
do_AzimuthAnalysisPlot(
  sample,
  annotation.labels,
  annotation.scoring,
  mapping.scoring = "mapping.score",
  annotation.cutoff = 0.75,
  mapping.cutoff = 0,
  group.by = NULL,
  ref.obj = NULL,
  ref.reduction = "ref.umap",
  raster = FALSE,
  pt.size = if (isTRUE(raster)) {
     4
 } else {
     1
 },
  raster.dpi = 2048,
  border.size = if (isTRUE(raster)) {
     1.25
 } else {
     1.5
 },
  border.color = "black",
  na.value = "grey75",
  font.size = 14,
  font.type = "sans",
  colors.use = NULL,
  label = TRUE,
  legend.position = "bottom",
  viridis_color_map = "G",
  viridis_direction = 1
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{annotation.labels}{\strong{\code{\link[base]{character}}} | Metadata column that stores the inferred annotation from Azimuth.}

\item{annotation.scoring}{\strong{\code{\link[base]{character}}} | Metadata column that stores the annotation scoring from Azimuth.}

\item{mapping.scoring}{\strong{\code{\link[base]{character}}} | Metadata column that stores the mapping scoring from Azimuth.}

\item{annotation.cutoff}{\strong{\code{\link[base]{numeric}}} | Value from 0 to 1 to use as cutoff to assign the labels to the object. This is used in conjunction with mapping.cutoff.}

\item{mapping.cutoff}{\strong{\code{\link[base]{numeric}}} | Value from 0 to 1 to use as cutoff to assign the labels to the object. This is used in conjunction with annotation.cutoff.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{ref.obj}{\strong{\code{\link[SeuratObject]{Seurat}}} | Seurat object used for reference mapping. Providing this object will add an extra plot with the UMAP of the reference and add its silhouette to the UMAP in which the original cells are showed in the context of the UMAP embedding of the reference object.}

\item{ref.reduction}{\strong{\code{\link[base]{character}}} | Name of the reduction embedding used to plot the UMAP in the reference object.}

\item{raster}{\strong{\code{\link[base]{logical}}} | Whether to raster the resulting plot. This is recommendable if plotting a lot of cells.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{raster.dpi}{\strong{\code{\link[base]{numeric}}} | Pixel resolution for rasterized plots. Defaults to 1024. Only activates on Seurat versions higher or equal than 4.1.0.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color to use for the border of the cells.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{label}{\strong{\code{\link[base]{logical}}} | Whether to plot the cluster labels in the UMAP. The cluster labels will have the same color as the cluster colors.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}
}
\value{
A list containing multiple plots.
}
\description{
This functions takes as input a Seurat object that has undergone reference mapping using Azimuth and
generates a set of visualizations and a combined output from the results of such mapping. The user can also
provide the reference object used for the mapping (if available) to produce a more complete output.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_AzimuthAnalysisPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object that has undergone Azimuth mapping.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Generate an Azimuth report.
    out <- SCpubr::do_AzimuthAnalysisPlot(sample = sample,
                                          annotation.labels = "annotation",
                                          annotation.scoring = "annotation.score",
                                          font.size = 18)

  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
