% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estMaxVlp.R
\name{est.maxvlp}
\alias{est.maxvlp}
\title{Estimate maximum one-way linear speed of a loop trip}
\usage{
est.maxvlp(sdata, qi = 4, prob = 0.99)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{qi}{An integer specifying the minimum quality index associated with a location used for the estimation. Default is 4.}

\item{prob}{A numeric value specifying a probability to obtain sample quantiles. Default is 0.99.}
}
\value{
A vector is returned. The unit is in kilometres per hour.
}
\description{
This function estimates the maximum one-way linear speed of a loop trip as described in Shimada et al. (2012).
}
\details{
The function first detects a "loop trip". 
Loop trip behaviour is represented by spatial departure and return with more than 3 consecutive locations (Shimada et al 2012). 
It then calculates the net (i.e. straight-line) distance between the departure and turning location as well as 
the turning and return location of the loop trip, and from that calculated the net speed in and out. 
It discards extreme values based on the quantile specified by a user (default is 0.99). 
This is to exclude outliers potentially contained in the original data set. 
The maximum value in the retained dataset (i.e. without outliers) represents the maximum one-way linear speed at which 
an animal would travel during a loop trip.
}
\note{
Input data must not contain temporal or spatial duplicates.
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) 
Improving data retention and home range estimates by data-driven screening. 
Marine Ecology Progress Series 457:171-180 doi:10.3354/meps09747
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter.loop}}
}
\author{
Takahiro Shimada
}
