% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfilter_speed.R
\name{ddfilter_speed}
\alias{ddfilter_speed}
\title{Filter locations by speed}
\usage{
ddfilter_speed(sdata, vmax = 8.9, method = 1)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
The function filters the input data by the unique "id". 
"DateTime" is date & time in class \code{\link[base]{POSIXct}}. 
"lat" and "lon" are the latitude and longitude of each location in decimal degrees. 
"qi" is the numerical quality index associated with each location fix where a greater number indicates a higher accuracy 
(e.g. number of GPS satellites used for estimation).}

\item{vmax}{A numeric value specifying a threshold of speed from a previous and/or to a subsequent fix. 
Default is 8.9km/h. 
If this value is unknown, it can be estimated from \emph{sdata} using the function \code{\link{vmax}}.}

\item{method}{An integer specifying how locations should be filtered with \emph{vmax}. 
A location is removed if the speed from a previous and(1)/or(2) to a subsequent location exceeds \emph{vmax}. 
Default is 1 (both way).}
}
\value{
The input data is returned without locations identified by this filter. 
The following columns are added: "pTime", "sTime", "pDist", "sDist", "pSpeed", "sSpeed". 
"pTime" and "sTime" are hours from a previous and to a subsequent fix respectively. 
"pDist" and "sDist" are straight distances in kilometres from a previous and to a subsequent fix respectively. 
"pSpeed" and "sSpeed" are linear speed from a previous and to a subsequent fix respectively.
}
\description{
A partial component of \code{\link{ddfilter}}, although works as a stand-alone function. 
This function removes locations by a given threshold speed as described in Shimada et al. (2012).
}
\details{
This function removes locations if the speed from a previous and/or to a subsequent location exceeds a given threshold speed. 
If \emph{vmax} is unknown, it can be estimated using the function \code{\link{vmax}}.
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) 
Improving data retention and home range estimates by data-driven screening.
\emph{Marine Ecology Progress Series} 457:171-180 doi:\href{http://doi.org/10.3354/meps09747}{10.3354/meps09747}
}
\seealso{
\code{\link{ddfilter}}, \code{\link{ddfilter_loop}}, \code{\link{vmax}}, \code{\link{track_param}}
}
\author{
Takahiro Shimada
}
