% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simulate_data_nonlinear}
\alias{simulate_data_nonlinear}
\title{Simulate data with linear confounding and non-linear causal effect}
\usage{
simulate_data_nonlinear(q, p, n, m, K = 2, eff = NULL, fixEff = FALSE)
}
\arguments{
\item{q}{number of confounding covariates in H}

\item{p}{number of covariates in X}

\item{n}{number of observations}

\item{m}{number of covariates with a causal effect on Y}

\item{K}{number of fourier basis functions K \eqn{K \in \mathbb{N}}, e.g. complexity of causal function}

\item{eff}{the number of affected covariates in X by the confounding, if NULL all covariates are affected}

\item{fixEff}{if eff is smaller than p: If fixEff = TRUE, the causal parents 
are always affected by confounding if fixEff = FALSE, affected covariates are chosen completely at random.}
}
\value{
a list containing the simulated data:
\item{X}{a matrix of covariates}
\item{Y}{a vector of responses}
\item{f_X}{a vector of the true function f(X)}
\item{j}{the indices of the causal covariates in X}
\item{beta}{the parameter vector for the function f(X), see \code{\link{f_four}}}
\item{H}{the matrix of confounding covariates}
}
\description{
Simulation of data from a confounded non-linear model. 
The data generating process is given by:
\deqn{Y = f(X) + \delta^T H  + \nu}
\deqn{X = \Gamma^T H + E}
where \eqn{f(X)} is a random function on the fourier basis
with a subset of size m covariates \eqn{X_j} having a causal effect on \eqn{Y}.
\deqn{f(x_i) = \sum_{j = 1}^p 1_{j \in js} \sum_{k = 1}^K (\beta_{j, k}^{(1)} \cos(0.2 k x_j) + 
\beta_{j, k}^{(2)} \sin(0.2 k x_j))}
\eqn{E}, \eqn{\nu} are random error terms and 
\eqn{H \in \mathbb{R}^{n \times q}} is a matrix of random confounding covariates.
\eqn{\Gamma \in \mathbb{R}^{q \times p}} and \eqn{\delta \in \mathbb{R}^{q}} are random coefficient vectors.
For the simulation, all the above parameters are drawn from a standard normal distribution, except for 
\eqn{\nu} which is drawn from a normal distribution with standard deviation 0.1.
The parameters \eqn{\beta} are drawn from a uniform distribution between -1 and 1.
}
\examples{
set.seed(42)
# simulation of confounded data
sim_data <- simulate_data_nonlinear(q = 2, p = 150, n = 100, m = 2)
X <- sim_data$X
Y <- sim_data$Y

}
\seealso{
\code{\link{f_four}}
}
\author{
Markus Ulmer
}
