% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_individual_fj}
\alias{predict_individual_fj}
\title{Predictions of individual component functions for SDAM}
\usage{
predict_individual_fj(object, j, newdata = NULL)
}
\arguments{
\item{object}{Fitted object of class \code{SDAM}.}

\item{j}{Which component to evaluate.}

\item{newdata}{New test data of class \code{data.frame} containing
the covariates for which to predict the response.}
}
\value{
A vector of predictions for fj evaluated at Xjnew.
}
\description{
Predicts the contribution of an individual component j using a fitted SDAM.
}
\examples{
set.seed(1)
X <- matrix(rnorm(10 * 5), ncol = 5)
Y <- sin(X[, 1]) -  X[, 2] + rnorm(10)
model <- SDAM(x = X, y = Y, Q_type = "trim", trim_quantile = 0.5, nfold = 2, n_K = 1)
predict_individual_fj(model, j = 1)
}
\seealso{
\code{\link{SDAM}}
}
\author{
Cyrill Scheidegger
}
