% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictOOB}
\alias{predictOOB}
\title{Out-of-bag predictions for the SDForest}
\usage{
predictOOB(object, X = NULL)
}
\arguments{
\item{object}{Fitted object of class \code{SDForest}.}

\item{X}{Covariates of the training data.
If \code{NULL}, the data saved in the object is used.}
}
\value{
A vector of out-of-bag predictions for the training data.
#' set.seed(1)
n <- 50
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDForest(x = X, y = y, Q_type = 'no_deconfounding', nTree = 5, cp = 0.5)
predictOOB(model)
}
\description{
Predicts the response for the training data 
using only the trees in the SDForest 
that were not trained on the observation.
}
\seealso{
\code{\link{SDForest}} \code{\link{prune.SDForest}} \code{\link{plotOOB}}
}
\author{
Markus Ulmer
}
