% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\title{AUC}
\usage{
auc(model, test = NULL, a = NULL)
}
\arguments{
\item{model}{\code{\linkS4class{SDMmodel}} or
\code{\linkS4class{SDMmodelCV}} objects.}

\item{test}{\code{\linkS4class{SWD}} test object for
\code{\linkS4class{SDMmodel}} objects or logical for
\code{\linkS4class{SDMmodelCV}} objects, if not provided it computes the
train AUC, default is \code{NULL}.}

\item{a}{Deprecated.}
}
\value{
The value of the AUC.
}
\description{
Compute the AUC using the Man-Whitney U Test formula.
}
\details{
If the model is a \code{\linkS4class{SDMmodelCV}} object, the
function computes the mean of the training or testing AUC values of the
different replicates.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data, test = 0.2, only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", data = train, fc = "l")

# Compute the training AUC
auc(model)

# Compute the testing AUC
auc(model, test = test)

\donttest{
# Same example but using cross validation instead of training and testing
# datasets
# Create the folds
folds <- randomFolds(data, k = 4, only_presence = TRUE)
model <- train(method = "Maxnet", data = data, fc = "l", folds = folds)

# Compute the training AUC
auc(model)

# Compute the testing AUC
auc(model, test = TRUE)
}
}
\references{
Mason, S. J. and Graham, N. E. (2002), Areas beneath the relative
operating characteristics (ROC) and relative operating levels (ROL) curves:
Statistical significance and interpretation. Q.J.R. Meteorol. Soc., 128:
2145-2166.
}
\author{
Sergio Vignali
}
