% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Landscape-Methods.R
\docType{methods}
\name{simulateThickMargins}
\alias{simulateThickMargins}
\alias{simulateThickMargins,Landscape-method}
\title{simulateThickMargins Method}
\usage{
simulateThickMargins(objectL, ...)

\S4method{simulateThickMargins}{Landscape}(objectL, border_size = 200,
  prob = runif(1, 0.1, 0.9), mean_thickness = runif(1, 2, 20),
  v_thickness = 50)
}
\arguments{
\item{objectL}{A Landscape object}

\item{...}{other parameters}

\item{border_size}{A numeric, bbox margin}

\item{prob}{Probability to inflate a margin}

\item{mean_thickness}{Margin width expectation in meter}

\item{v_thickness}{Margin width variance in meter}
}
\value{
a Landscape object with fields margin as receptor
}
\description{
Simulate thick margins as receptors in a landscape.
}
\details{
Margin width use a Gamma distribution with shape and scale parameters based on thickness mean and variance.
}
\seealso{
\link{simulateInitialPartition} and \link{simulateLandscape}
}

