% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedGraph.R
\name{getHalfTrekSystem}
\alias{getHalfTrekSystem}
\alias{getHalfTrekSystem.MixedGraphFixedOrder}
\alias{getHalfTrekSystem.MixedGraph}
\title{Determines if a half-trek system exists in the mixed graph.}
\usage{
getHalfTrekSystem(this, fromNodes, toNodes)

\method{getHalfTrekSystem}{MixedGraphFixedOrder}(this, fromNodes, toNodes)

\method{getHalfTrekSystem}{MixedGraph}(this, fromNodes, toNodes)
}
\arguments{
\item{this}{the mixed graph object}

\item{fromNodes}{the nodes from which the half-trek system should start.
If length(fromNodes) > length(toNodes) will find if there exists
any half-trek system from any subset of fromNodes of size
length(toNodes) to toNodes.}

\item{toNodes}{the nodes where the half-trek system should end.}
}
\value{
a list with two named components, \code{systemExists} (TRUE if a
        system exists, FALSE otherwise) and \code{activeFrom} (the subset
        of fromNodes from which the maximal half-trek system was started).
}
\description{
Determines if a half-trek system exists in the mixed graph.
}
